/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import java.net.URI;

@SdkInternalApi
class SigningCertUrlVerifier {
    private final String endpoint;

    SigningCertUrlVerifier(String endpoint) {
        this.endpoint = endpoint;
    }

    void verifyCertUrl(URI certUrl) {
        this.assertIsHttps(certUrl);
        this.assertIsFromSns(certUrl);
    }

    private void assertIsHttps(URI certUrl) {
        if (!"https".equals(certUrl.getScheme())) {
            throw new SdkClientException("SigningCertURL was not using HTTPS: " + certUrl.toString());
        }
    }

    private void assertIsFromSns(URI certUrl) {
        if (!this.endpoint.equals(certUrl.getHost())) {
            throw new SdkClientException(String.format("SigningCertUrl does not match expected endpoint. Expected %s but received endpoint was %s.", this.endpoint, certUrl.getHost()));
        }
    }
}

