/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.io.IOException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class SearchDataObjectResponse {
    private final XContentParser parser;
    private final SearchResponse searchResponse;

    public SearchDataObjectResponse(SearchResponse searchResponse) {
        this.searchResponse = searchResponse;
        this.parser = null;
    }

    public SearchDataObjectResponse(XContentParser parser) {
        this.parser = parser;
        this.searchResponse = null;
    }

    @Nullable
    public SearchResponse searchResponse() {
        if (this.searchResponse == null) {
            try {
                return SearchResponse.fromXContent((XContentParser)this.parser);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.searchResponse;
    }

    public XContentParser parser() {
        if (this.parser == null) {
            try {
                return SdkClientUtils.createParser((ToXContent)this.searchResponse);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.parser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private XContentParser parser = null;

        private Builder() {
        }

        public Builder parser(XContentParser parser) {
            this.parser = parser;
            return this;
        }

        public SearchDataObjectResponse build() {
            return new SearchDataObjectResponse(this.parser);
        }
    }
}

