/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Normalizer;
import org.opensearch.client.opensearch._types.analysis.NormalizerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CustomNormalizer
implements NormalizerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, CustomNormalizer> {
    @Nonnull
    private final List<String> charFilter;
    @Nonnull
    private final List<String> filter;
    public static final JsonpDeserializer<CustomNormalizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomNormalizer::setupCustomNormalizerDeserializer);

    private CustomNormalizer(Builder builder) {
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
    }

    public static CustomNormalizer of(Function<Builder, ObjectBuilder<CustomNormalizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Normalizer.Kind _normalizerKind() {
        return Normalizer.Kind.Custom;
    }

    @Nonnull
    public final List<String> charFilter() {
        return this.charFilter;
    }

    @Nonnull
    public final List<String> filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCustomNormalizerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.charFilter);
        result = 31 * result + Objects.hashCode(this.filter);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomNormalizer other = (CustomNormalizer)o;
        return Objects.equals(this.charFilter, other.charFilter) && Objects.equals(this.filter, other.filter);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CustomNormalizer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;

        public Builder() {
        }

        private Builder(CustomNormalizer o) {
            this.charFilter = Builder._listCopy(o.charFilter);
            this.filter = Builder._listCopy(o.filter);
        }

        private Builder(Builder o) {
            this.charFilter = Builder._listCopy(o.charFilter);
            this.filter = Builder._listCopy(o.filter);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder charFilter(List<String> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        @Nonnull
        public final Builder charFilter(String value, String ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(List<String> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        @Nonnull
        public final Builder filter(String value, String ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CustomNormalizer build() {
            this._checkSingleUse();
            return new CustomNormalizer(this);
        }
    }
}

