/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonValueBase;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;

public final class JsonFlattenerFactory {
    private final Consumer<JsonFlattener> configurer;
    private final Optional<JsonCore<?>> jsonCore;

    public JsonFlattenerFactory(Consumer<JsonFlattener> configurer) {
        this.configurer = (Consumer)Validate.notNull(configurer);
        this.jsonCore = Optional.empty();
    }

    public JsonFlattenerFactory(Consumer<JsonFlattener> configurer, JsonCore<?> jsonCore) {
        this.configurer = (Consumer)Validate.notNull(configurer);
        this.jsonCore = Optional.of(jsonCore);
    }

    public JsonFlattener build(String json) {
        JsonFlattener jf = this.jsonCore.isPresent() ? new JsonFlattener(this.jsonCore.get(), json) : new JsonFlattener(json);
        this.configurer.accept(jf);
        return jf;
    }

    public JsonFlattener build(JsonValueBase<?> json) {
        JsonFlattener jf = this.jsonCore.isPresent() ? new JsonFlattener(this.jsonCore.get(), json) : new JsonFlattener(json);
        this.configurer.accept(jf);
        return jf;
    }

    public JsonFlattener build(Reader jsonReader) throws IOException {
        JsonFlattener jf = this.jsonCore.isPresent() ? new JsonFlattener(this.jsonCore.get(), jsonReader) : new JsonFlattener(jsonReader);
        this.configurer.accept(jf);
        return jf;
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.configurer.hashCode();
        result = 31 * result + this.jsonCore.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattenerFactory)) {
            return false;
        }
        JsonFlattenerFactory other = (JsonFlattenerFactory)o;
        return this.configurer.equals(other.configurer) && this.jsonCore.equals(other.jsonCore);
    }

    public String toString() {
        return "JsonFlattenerFactory{configurer=" + this.configurer + ", jsonCore=" + this.jsonCore + "}";
    }
}

