/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropTableStep;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropTableImpl
extends AbstractQuery
implements DropTableStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_TABLE};
    private final Table<?> table;
    private final boolean ifExists;
    private boolean cascade;

    DropTableImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false);
    }

    DropTableImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
    }

    @Override
    public final DropTableImpl cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final DropTableImpl restrict() {
        this.cascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_TABLE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_TABLE);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_TABLE_TABLE).visit(Keywords.K_DROP_TABLE).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.table);
        if (this.cascade) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        }
        ctx.end(Clause.DROP_TABLE_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

