/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/reportsscheduler/model/GetAllReportDefinitionsRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "fromIndex", "", "maxItems", "<init>", "(II)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFromIndex", "()I", "getMaxItems", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "builder", "Companion", "opensearch-reports-scheduler"})
public final class GetAllReportDefinitionsRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int fromIndex;
    private final int maxItems;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(GetAllReportDefinitionsRequest.class);

    public GetAllReportDefinitionsRequest(int fromIndex, int maxItems) {
        this.fromIndex = fromIndex;
        this.maxItems = maxItems;
    }

    public final int getFromIndex() {
        return this.fromIndex;
    }

    public final int getMaxItems() {
        return this.maxItems;
    }

    public GetAllReportDefinitionsRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(input.readInt(), input.readInt());
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeInt(this.fromIndex);
        output.writeInt(this.maxItems);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException actionRequestValidationException;
        if (this.fromIndex < 0) {
            void var1_1;
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("fromIndex should be greater than 0");
            Metrics.REPORT_DEFINITION_LIST_USER_ERROR_INVALID_FROM_INDEX.getCounter().increment();
            actionRequestValidationException = var1_1;
        } else {
            actionRequestValidationException = null;
        }
        return actionRequestValidationException;
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(GetAllReportDefinitionsRequest getAllReportDefinitionsRequest, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return getAllReportDefinitionsRequest.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        XContentBuilder xContentBuilder2 = xContentBuilder.startObject().field("fromIndex", this.fromIndex).field("maxItems", this.maxItems).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/reportsscheduler/model/GetAllReportDefinitionsRequest$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/reportsscheduler/model/GetAllReportDefinitionsRequest;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final GetAllReportDefinitionsRequest parse(@NotNull XContentParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            int fromIndex = 0;
            int maxItems = PluginSettings.INSTANCE.getDefaultItemsQueryCount();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"fromIndex")) {
                    fromIndex = parser.intValue();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"maxItems")) {
                    maxItems = parser.intValue();
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("reports:Skipping Unknown field " + fieldName);
            }
            return new GetAllReportDefinitionsRequest(fromIndex, maxItems);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

