/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedByIteratorBase;
import com.azure.core.util.paging.ContinuationState;
import com.azure.core.util.paging.PageRetriever;
import com.azure.core.util.paging.PageRetrieverSync;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

final class ContinuablePagedByPageIterable<C, T, P extends ContinuablePage<C, T>>
implements Iterable<P> {
    private final PageRetriever<C, P> pageRetriever;
    private final PageRetrieverSync<C, P> pageRetrieverSync;
    private final C continuationToken;
    private final Predicate<C> continuationPredicate;
    private final Integer preferredPageSize;

    ContinuablePagedByPageIterable(PageRetriever<C, P> pageRetriever, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
        this.pageRetriever = pageRetriever;
        this.continuationToken = continuationToken;
        this.continuationPredicate = continuationPredicate;
        this.preferredPageSize = preferredPageSize;
        this.pageRetrieverSync = null;
    }

    ContinuablePagedByPageIterable(PageRetrieverSync<C, P> pageRetrieverSync, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
        this.pageRetrieverSync = pageRetrieverSync;
        this.continuationToken = continuationToken;
        this.continuationPredicate = continuationPredicate;
        this.preferredPageSize = preferredPageSize;
        this.pageRetriever = null;
    }

    @Override
    public Iterator<P> iterator() {
        if (this.pageRetriever != null) {
            return new ContinuablePagedByPageIterator(this.pageRetriever, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
        }
        return new ContinuablePagedByPageIterator(this.pageRetrieverSync, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
    }

    private static final class ContinuablePagedByPageIterator<C, T, P extends ContinuablePage<C, T>>
    extends ContinuablePagedByIteratorBase<C, T, P, P> {
        private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedByPageIterator.class);
        private volatile Queue<P> pages = new ConcurrentLinkedQueue<P>();

        ContinuablePagedByPageIterator(PageRetriever<C, P> pageRetriever, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
            super(pageRetriever, new ContinuationState<C>(continuationToken, continuationPredicate), preferredPageSize, LOGGER);
            this.requestPage();
        }

        ContinuablePagedByPageIterator(PageRetrieverSync<C, P> pageRetrieverSync, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
            super(pageRetrieverSync, new ContinuationState<C>(continuationToken, continuationPredicate), preferredPageSize, LOGGER);
            this.requestPage();
        }

        @Override
        boolean needToRequestPage() {
            return this.pages.peek() == null;
        }

        @Override
        public boolean isNextAvailable() {
            return this.pages.peek() != null;
        }

        @Override
        P getNext() {
            return (P)((ContinuablePage)this.pages.poll());
        }

        @Override
        void addPage(P page) {
            this.pages.add(page);
        }
    }
}

