/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.util.LoggingUtil;
import reactor.core.publisher.Mono;

public class AzureDeveloperCliCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDeveloperCliCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    AzureDeveloperCliCredential(String tenantId, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).identityClientOptions(identityClientOptions);
        this.identityClient = builder.build();
        this.identitySyncClient = builder.buildSyncClient();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithAzureDeveloperCli(request).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error)).onErrorMap(error -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(error.getMessage(), (Throwable)error);
            }
            return error;
        });
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        try {
            AccessToken accessToken = this.identitySyncClient.authenticateWithAzureDeveloperCli(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return accessToken;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                throw new CredentialUnavailableException(e.getMessage(), e);
            }
            throw e;
        }
    }
}

