/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.OnBehalfOfCredential;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.function.Supplier;

public class OnBehalfOfCredentialBuilder
extends AadCredentialBuilderBase<OnBehalfOfCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredentialBuilder.class);
    private static final String CLASS_NAME = OnBehalfOfCredentialBuilder.class.getSimpleName();
    private String clientSecret;
    private String clientCertificatePath;
    private String clientCertificatePassword;
    private Supplier<String> clientAssertionSupplier;

    public OnBehalfOfCredentialBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OnBehalfOfCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public OnBehalfOfCredentialBuilder pemCertificate(String pemCertificatePath) {
        this.clientCertificatePath = pemCertificatePath;
        return this;
    }

    public OnBehalfOfCredentialBuilder pfxCertificate(String pfxCertificatePath) {
        this.clientCertificatePath = pfxCertificatePath;
        return this;
    }

    public OnBehalfOfCredentialBuilder clientCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public OnBehalfOfCredentialBuilder sendCertificateChain(boolean sendCertificateChain) {
        this.identityClientOptions.setIncludeX5c(sendCertificateChain);
        return this;
    }

    public OnBehalfOfCredentialBuilder userAssertion(String userAssertion) {
        this.identityClientOptions.userAssertion(userAssertion);
        return this;
    }

    public OnBehalfOfCredentialBuilder clientAssertion(Supplier<String> clientAssertionSupplier) {
        this.clientAssertionSupplier = clientAssertionSupplier;
        return this;
    }

    public OnBehalfOfCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "tenantId", this.tenantId);
        if (this.clientSecret == null && this.clientCertificatePath == null && this.clientAssertionSupplier == null || this.clientSecret != null && this.clientCertificatePath != null || this.clientSecret != null && this.clientAssertionSupplier != null || this.clientCertificatePath != null && this.clientAssertionSupplier != null) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Exactly one of client secret, client certificate path, or client assertion supplier must be provided in OnBehalfOfCredentialBuilder."));
        }
        return new OnBehalfOfCredential(this.clientId, this.tenantId, this.clientSecret, this.clientCertificatePath, this.clientCertificatePassword, this.clientAssertionSupplier, this.identityClientOptions);
    }
}

