/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.mustache.SearchTemplateResponse;

public class MultiSearchTemplateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private final Item[] items;
    private final long tookInMillis;

    MultiSearchTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.items = (Item[])in.readArray(Item::new, Item[]::new);
        this.tookInMillis = in.readVLong();
    }

    MultiSearchTemplateResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.items);
        out.writeVLong(this.tookInMillis);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            if (item.isFailure()) {
                builder.startObject();
                OpenSearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)item.getFailure(), (boolean)true);
                builder.field("status", ExceptionsHelper.status((Throwable)item.getFailure()).getStatus());
                builder.endObject();
                continue;
            }
            item.getResponse().toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchTemplateResponse fromXContext(XContentParser parser) {
        MultiSearchResponse mSearchResponse = MultiSearchResponse.fromXContext((XContentParser)parser);
        MultiSearchResponse.Item[] responses = mSearchResponse.getResponses();
        Item[] templateResponses = new Item[responses.length];
        int i = 0;
        for (MultiSearchResponse.Item item : responses) {
            SearchTemplateResponse stResponse = null;
            if (item.getResponse() != null) {
                stResponse = new SearchTemplateResponse();
                stResponse.setResponse(item.getResponse());
            }
            templateResponses[i++] = new Item(stResponse, item.getFailure());
        }
        return new MultiSearchTemplateResponse(templateResponses, mSearchResponse.getTook().millis());
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public static class Item
    implements Writeable {
        private final SearchTemplateResponse response;
        private final Exception exception;

        private Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchTemplateResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        public Item(SearchTemplateResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchTemplateResponse getResponse() {
            return this.response;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException((Throwable)this.exception);
            }
        }

        public Exception getFailure() {
            return this.exception;
        }

        public String toString() {
            return "Item [response=" + String.valueOf((Object)this.response) + ", exception=" + String.valueOf(this.exception) + "]";
        }
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }
}

