/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.configupdate;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ConfigUpdateRequest
extends BaseNodesRequest<ConfigUpdateRequest> {
    private String[] configTypes;
    private String[] entityNames;

    public ConfigUpdateRequest(StreamInput in) throws IOException {
        super(in);
        this.configTypes = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_3_1_0)) {
            this.entityNames = in.readOptionalStringArray();
        }
    }

    public ConfigUpdateRequest() {
        super(new String[0]);
    }

    public ConfigUpdateRequest(String[] configTypes) {
        this();
        this.setConfigTypes(configTypes);
    }

    public ConfigUpdateRequest(String configType, String[] entityNames) {
        this();
        this.setConfigTypes(new String[]{configType});
        this.setEntityNames(entityNames);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.configTypes);
        if (out.getVersion().onOrAfter(Version.V_3_1_0)) {
            out.writeOptionalStringArray(this.entityNames);
        }
    }

    public String[] getConfigTypes() {
        return this.configTypes;
    }

    public void setConfigTypes(String[] configTypes) {
        this.configTypes = configTypes;
    }

    public String[] getEntityNames() {
        return this.entityNames;
    }

    public void setEntityNames(String[] entityNames) {
        this.entityNames = entityNames;
    }

    public ActionRequestValidationException validate() {
        if (this.configTypes == null || this.configTypes.length == 0) {
            return new ActionRequestValidationException();
        }
        if (this.configTypes.length > 1 && this.entityNames != null && this.entityNames.length > 1) {
            return new ActionRequestValidationException();
        }
        return null;
    }
}

