/*
 * Decompiled with CFR 0.152.
 */
package com.password4j.types;

public enum Hmac {
    SHA1(160, 1),
    SHA224(224, 2),
    SHA256(256, 3),
    SHA384(384, 4),
    SHA512(512, 5);

    private final int bits;
    private final int code;

    private Hmac(int bits, int code) {
        this.bits = bits;
        this.code = code;
    }

    public static Hmac fromCode(int code) {
        for (Hmac alg : Hmac.values()) {
            if (alg.code() != code) continue;
            return alg;
        }
        return null;
    }

    public int bits() {
        return this.bits;
    }

    public int code() {
        return this.code;
    }

    public String toString() {
        return "PBKDF2WithHmac" + this.name();
    }
}

