/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;

public final class HttpServletRequestResponseContext {
    @Nonnull
    private static final ThreadLocal<HttpServletRequest> currentRequest = new ThreadLocal();
    @Nonnull
    private static final ThreadLocal<HttpServletResponse> currentResponse = new ThreadLocal();

    private HttpServletRequestResponseContext() {
    }

    public static void loadCurrent(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Constraint.isNotNull(request, "HttpServletRequest may not be null");
        Constraint.isNotNull(response, "HttpServletResponse may not be null");
        currentRequest.set(request);
        currentResponse.set(response);
    }

    public static void clearCurrent() {
        currentRequest.remove();
        currentResponse.remove();
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        return currentRequest.get();
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return currentResponse.get();
    }
}

