/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.BaseSAMLHttpServletRequestDecoder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;

public class HTTPPostDecoder
extends BaseSAMLHttpServletRequestDecoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostDecoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    @Override
    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        String relayState = request.getParameter("RelayState");
        this.log.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState(messageContext, relayState);
        try (InputStream base64DecodedMessage = this.getBase64DecodedMessage(request);){
            SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(base64DecodedMessage);
            messageContext.setMessage(inboundMessage);
            this.log.debug("Decoded SAML message");
        }
        catch (IOException e) {
            throw new MessageDecodingException(e);
        }
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext);
    }

    @Nonnull
    protected InputStream getBase64DecodedMessage(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        this.log.debug("Getting Base64 encoded message from request");
        String encodedMessage = request.getParameter("SAMLRequest");
        if (Strings.isNullOrEmpty((String)encodedMessage)) {
            encodedMessage = request.getParameter("SAMLResponse");
        }
        if (Strings.isNullOrEmpty((String)encodedMessage)) {
            this.log.error("Request did not contain either a SAMLRequest or SAMLResponse paramter.  Invalid request for SAML 2 HTTP POST binding.");
            throw new MessageDecodingException("No SAML message present in request");
        }
        assert (encodedMessage != null);
        try {
            this.log.trace("Base64 decoding SAML message:\n{}", (Object)encodedMessage);
            byte[] decodedBytes = Base64Support.decode(encodedMessage);
            this.log.trace("Decoded SAML message:\n{}", (Object)new String(decodedBytes));
            return new ByteArrayInputStream(decodedBytes);
        }
        catch (DecodingException e) {
            this.log.error("Unable to Base64 decode SAML message");
            throw new MessageDecodingException("Unable to Base64 decode SAML message", e);
        }
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned(messageContext));
    }
}

