/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class SAML2AuthnRequestsSignedSecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2AuthnRequestsSignedSecurityHandler.class);

    @Override
    public void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Object samlMessage = messageContext.getMessage();
        if (!(samlMessage instanceof AuthnRequest)) {
            this.log.debug("Inbound message is not an instance of AuthnRequest, skipping evaluation...");
            return;
        }
        if (this.isRequestSigningRequired(messageContext) && !this.isMessageSigned(messageContext)) {
            this.log.warn("Inbound AuthnRequest message was not signed");
            throw new MessageHandlerException("Inbound AuthnRequest was required to be signed but was not");
        }
    }

    protected boolean isMessageSigned(@Nonnull MessageContext messageContext) {
        return SAMLBindingSupport.isMessageSigned(messageContext);
    }

    protected boolean isRequestSigningRequired(@Nonnull MessageContext messageContext) {
        SAMLPeerEntityContext peerContext = messageContext.ensureSubcontext(SAMLPeerEntityContext.class);
        if (peerContext == null || Strings.isNullOrEmpty((String)peerContext.getEntityId())) {
            this.log.warn("SAML peer entityID was not available, unable to evaluate rule");
            return false;
        }
        String messageIssuer = peerContext.getEntityId();
        SAMLMetadataContext metadataContext = peerContext.ensureSubcontext(SAMLMetadataContext.class);
        if (metadataContext == null || metadataContext.getRoleDescriptor() == null) {
            this.log.warn("SAMLPeerContext did not contain either a SAMLMetadataContext or a RoleDescriptor, unable to evaluate rule");
            return false;
        }
        if (!(metadataContext.getRoleDescriptor() instanceof SPSSODescriptor)) {
            RoleDescriptor role = metadataContext.getRoleDescriptor();
            this.log.warn("RoleDescriptor was not an SPSSODescriptor, it was a {}. Unable to evaluate rule", (Object)(role != null ? role.getClass().getName() : "(null)"));
            return false;
        }
        SPSSODescriptor spssoRole = (SPSSODescriptor)metadataContext.getRoleDescriptor();
        assert (spssoRole != null);
        if (Boolean.TRUE.equals(spssoRole.isAuthnRequestsSigned())) {
            this.log.debug("SPSSODescriptor for entity ID '{}' indicates AuthnRequests must be signed", (Object)messageIssuer);
            return true;
        }
        this.log.debug("SPSSODescriptor for entity ID '{}' does not require AuthnRequests to be signed", (Object)messageIssuer);
        return false;
    }
}

