/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.saml2.common.CacheableSAMLObject;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.w3c.dom.Element;

public abstract class RoleDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        List<String> supportedProtocols;
        Duration d;
        Instant i;
        RoleDescriptor roleDescriptor = (RoleDescriptor)xmlObject;
        if (roleDescriptor.getID() != null) {
            domElement.setAttributeNS(null, "ID", roleDescriptor.getID());
        }
        if ((i = roleDescriptor.getValidUntil()) != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, TimeBoundSAMLObject.VALID_UNTIL_ATTRIB_QNAME, i);
        }
        if ((d = roleDescriptor.getCacheDuration()) != null) {
            AttributeSupport.appendDurationAttribute(domElement, CacheableSAMLObject.CACHE_DURATION_ATTRIB_QNAME, d);
        }
        if ((supportedProtocols = roleDescriptor.getSupportedProtocols()) != null && !supportedProtocols.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String protocol : supportedProtocols) {
                builder.append(protocol);
                builder.append(" ");
            }
            domElement.setAttributeNS(null, "protocolSupportEnumeration", builder.toString().trim());
        }
        if (roleDescriptor.getErrorURL() != null) {
            domElement.setAttributeNS(null, "errorURL", roleDescriptor.getErrorURL());
        }
        this.marshallUnknownAttributes(roleDescriptor, domElement);
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(null, "ID", domElement, true);
        super.marshallAttributeIDness(xmlObject, domElement);
    }
}

