/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.metadata.support.AttributeConsumingServiceSelector;
import org.opensaml.saml.metadata.support.SAML2MetadataSupport;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.SSODescriptorImpl;

public class SPSSODescriptorImpl
extends SSODescriptorImpl
implements SPSSODescriptor {
    @Nullable
    private XSBooleanValue authnRequestSigned;
    @Nullable
    private XSBooleanValue assertionSigned;
    @Nonnull
    private final XMLObjectChildrenList<AssertionConsumerService> assertionConsumerServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<AttributeConsumingService> attributeConsumingServices = new XMLObjectChildrenList(this);

    protected SPSSODescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public Boolean isAuthnRequestsSigned() {
        if (this.authnRequestSigned != null) {
            return this.authnRequestSigned.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public XSBooleanValue isAuthnRequestsSignedXSBoolean() {
        return this.authnRequestSigned;
    }

    @Override
    public void setAuthnRequestsSigned(@Nullable Boolean newIsSigned) {
        this.authnRequestSigned = newIsSigned != null ? this.prepareForAssignment(this.authnRequestSigned, new XSBooleanValue(newIsSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, null);
    }

    @Override
    public void setAuthnRequestsSigned(@Nullable XSBooleanValue isSigned) {
        this.authnRequestSigned = this.prepareForAssignment(this.authnRequestSigned, isSigned);
    }

    @Override
    @Nullable
    public Boolean getWantAssertionsSigned() {
        if (this.assertionSigned != null) {
            return this.assertionSigned.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public XSBooleanValue getWantAssertionsSignedXSBoolean() {
        return this.assertionSigned;
    }

    @Override
    public void setWantAssertionsSigned(@Nullable Boolean wantAssestionSigned) {
        this.assertionSigned = wantAssestionSigned != null ? this.prepareForAssignment(this.assertionSigned, new XSBooleanValue(wantAssestionSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, null);
    }

    @Override
    public void setWantAssertionsSigned(@Nullable XSBooleanValue wantAssestionSigned) {
        this.assertionSigned = this.prepareForAssignment(this.assertionSigned, wantAssestionSigned);
    }

    @Override
    @Nonnull
    @Live
    public List<AssertionConsumerService> getAssertionConsumerServices() {
        return this.assertionConsumerServices;
    }

    @Override
    @Nullable
    public AssertionConsumerService getDefaultAssertionConsumerService() {
        return SAML2MetadataSupport.getDefaultIndexedEndpoint(this.assertionConsumerServices);
    }

    @Override
    @Nonnull
    @Live
    public List<AttributeConsumingService> getAttributeConsumingServices() {
        return this.attributeConsumingServices;
    }

    @Override
    @Nullable
    public AttributeConsumingService getDefaultAttributeConsumingService() {
        AttributeConsumingServiceSelector selector = new AttributeConsumingServiceSelector();
        selector.setRoleDescriptor(this);
        return selector.selectService();
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.addAll(super.getEndpoints());
        endpoints.addAll(this.assertionConsumerServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(AssertionConsumerService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.assertionConsumerServices);
        }
        return super.getEndpoints(type);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll(this.assertionConsumerServices);
        children.addAll(this.attributeConsumingServices);
        return CollectionSupport.copyToList(children);
    }
}

