/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.SecurityTokenReference;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectMarshaller;
import org.w3c.dom.Element;

public class SecurityTokenReferenceMarshaller
extends AbstractWSSecurityObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        List<String> usages;
        SecurityTokenReference str = (SecurityTokenReference)xmlObject;
        if (!Strings.isNullOrEmpty((String)str.getWSUId())) {
            XMLObjectSupport.marshallAttribute(SecurityTokenReference.WSU_ID_ATTR_NAME, str.getWSUId(), domElement, true);
        }
        if ((usages = str.getWSSEUsages()) != null && !usages.isEmpty()) {
            XMLObjectSupport.marshallAttribute(SecurityTokenReference.WSSE_USAGE_ATTR_NAME, usages, domElement, false);
        }
        XMLObjectSupport.marshallAttributeMap(str.getUnknownAttributes(), domElement);
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(SecurityTokenReference.WSU_ID_ATTR_NAME, domElement, true);
        super.marshallAttributeIDness(xmlObject, domElement);
    }
}

