/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.criterion;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.xmlsec.EncryptionConfiguration;

public class EncryptionConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<EncryptionConfiguration> configs;

    public EncryptionConfigurationCriterion(@Nonnull @NotEmpty List<EncryptionConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    public EncryptionConfigurationCriterion(EncryptionConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf(Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    public List<EncryptionConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EncryptionConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EncryptionConfigurationCriterion) {
            EncryptionConfigurationCriterion other = (EncryptionConfigurationCriterion)obj;
            return this.configs.equals(other.getConfigurations());
        }
        return false;
    }
}

