/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.AbstractEncryptedKeyResolver;
import org.opensaml.xmlsec.signature.KeyInfo;

public class InlineEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    public InlineEncryptedKeyResolver() {
    }

    @Deprecated
    public InlineEncryptedKeyResolver(@Nullable Set<String> recipients) {
        super(recipients);
    }

    @Deprecated
    public InlineEncryptedKeyResolver(@Nullable String recipient) {
        this(recipient != null ? CollectionSupport.singleton(recipient) : null);
    }

    @Override
    @Nonnull
    public Iterable<EncryptedKey> resolve(@Nonnull EncryptedData encryptedData, @Nullable Set<String> recipients) {
        Constraint.isNotNull(encryptedData, "EncryptedData cannot be null");
        KeyInfo keyInfo = encryptedData.getKeyInfo();
        if (keyInfo == null) {
            return CollectionSupport.emptyList();
        }
        return keyInfo.getEncryptedKeys().stream().filter(ek -> this.matchRecipient(ek.getRecipient(), this.getEffectiveRecipients(recipients))).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get();
    }
}

