/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.AbstractDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;

public class JacksonDeserializer<T>
extends AbstractDeserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(Map<String, Class<?>> claimTypeMap) {
        this(JacksonSerializer.newObjectMapper(), claimTypeMap);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Map<String, Class<?>> claimTypeMap) {
        this(objectMapper);
        Assert.notNull(claimTypeMap, (String)"Claim type map cannot be null.");
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Object.class, (JsonDeserializer)new MappedTypeDeserializer(Collections.unmodifiableMap(claimTypeMap)));
        objectMapper.registerModule((Module)module);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> returnType) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper cannot be null.");
        Assert.notNull(returnType, (String)"Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = returnType;
    }

    protected T doDeserialize(Reader reader) throws Exception {
        return (T)this.objectMapper.readValue(reader, this.returnType);
    }

    private static class MappedTypeDeserializer
    extends UntypedObjectDeserializer {
        private final Map<String, Class<?>> claimTypeMap;

        private MappedTypeDeserializer(Map<String, Class<?>> claimTypeMap) {
            super(null, null);
            this.claimTypeMap = claimTypeMap;
        }

        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String name = parser.currentName();
            if (this.claimTypeMap != null && name != null && this.claimTypeMap.containsKey(name)) {
                Class<?> type = this.claimTypeMap.get(name);
                return parser.readValueAsTree().traverse(parser.getCodec()).readValueAs(type);
            }
            return super.deserialize(parser, context);
        }
    }
}

