/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;

public class LdapURL {
    public static final String NO_DELIMITER = "NO-DELIMITER";
    private static final String DEFAULT_DELIMITER = " ";
    private static final Pattern URL_PATTERN = Pattern.compile("([lL][dD][aA][pP][sSiI]?)://([^:/]+)?(?::(\\d+))?(?:/(?:([^?]+))?(?:\\?([^?]*))?(?:\\?([^?]*))?(?:\\?(.*))?)?");
    private final List<Entry> ldapEntries = new ArrayList<Entry>();

    public LdapURL(String url) {
        this(url, DEFAULT_DELIMITER);
    }

    public LdapURL(String url, String delimiter) {
        String[] urls = NO_DELIMITER.equals(delimiter) ? new String[]{url} : url.split(delimiter);
        for (String s : urls) {
            this.ldapEntries.add(this.parseEntry(s));
        }
    }

    protected Entry parseEntry(String url) {
        String baseDn;
        Matcher m = URL_PATTERN.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid LDAP URL: " + url);
        }
        String scheme = m.group(1).toLowerCase();
        String hostname = m.group(2);
        if (hostname != null && hostname.startsWith("[") && hostname.endsWith("]")) {
            hostname = hostname.substring(1, hostname.length() - 1).trim();
        }
        int port = m.group(3) != null ? Integer.parseInt(m.group(3)) : -1;
        String string = baseDn = m.group(4) != null ? LdapUtils.percentDecode(m.group(4)) : null;
        String[] attributes = m.group(5) != null ? (m.group(5).length() > 0 ? m.group(5).split(",") : null) : null;
        String scope = m.group(6);
        SearchScope searchScope = null;
        if (scope != null && scope.length() > 0) {
            if ("base".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.OBJECT;
            } else if ("one".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.ONELEVEL;
            } else if ("sub".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.SUBTREE;
            } else {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
        SearchFilter filter = m.group(7) != null ? (m.group(7).length() > 0 ? new SearchFilter(LdapUtils.percentDecode(m.group(7))) : null) : null;
        return new Entry(scheme, hostname, port, baseDn, attributes, searchScope, filter);
    }

    public Entry getEntry() {
        return this.ldapEntries.get(0);
    }

    public Entry getLastEntry() {
        return this.ldapEntries.get(this.ldapEntries.size() - 1);
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.ldapEntries);
    }

    public String[] getUrls() {
        String[] entries = new String[this.ldapEntries.size()];
        for (int i = 0; i < this.ldapEntries.size(); ++i) {
            entries[i] = this.ldapEntries.get(i).getUrl();
        }
        return entries;
    }

    public String[] getHostnamesWithSchemeAndPort() {
        String[] entries = new String[this.ldapEntries.size()];
        for (int i = 0; i < this.ldapEntries.size(); ++i) {
            entries[i] = this.ldapEntries.get(i).getHostnameWithSchemeAndPort();
        }
        return entries;
    }

    public String[] getHostnames() {
        String[] entries = new String[this.ldapEntries.size()];
        for (int i = 0; i < this.ldapEntries.size(); ++i) {
            entries[i] = this.ldapEntries.get(i).getHostname();
        }
        return entries;
    }

    public int size() {
        return this.ldapEntries.size();
    }

    public String toString() {
        return String.format("[%s@%d::ldapEntries=%s]", this.getClass().getName(), this.hashCode(), this.ldapEntries);
    }

    public static class Entry {
        protected static final int DEFAULT_LDAP_PORT = 389;
        protected static final int DEFAULT_LDAPS_PORT = 636;
        protected static final String DEFAULT_BASE_DN = "";
        protected static final SearchFilter DEFAULT_FILTER = new SearchFilter("(objectClass=*)");
        protected static final SearchScope DEFAULT_SCOPE = SearchScope.OBJECT;
        protected static final String[] DEFAULT_ATTRIBUTES = ReturnAttributes.DEFAULT.value();
        private final String urlScheme;
        private final String urlHostname;
        private final int urlPort;
        private final String urlBaseDn;
        private final String[] urlAttributes;
        private final SearchScope urlScope;
        private final SearchFilter urlFilter;

        public Entry(String scheme, String hostname, int port, String baseDn, String[] attributes, SearchScope scope, SearchFilter filter) {
            if (scheme == null) {
                throw new IllegalArgumentException("Scheme cannot be null");
            }
            this.urlScheme = scheme;
            this.urlHostname = hostname;
            this.urlPort = port;
            this.urlBaseDn = baseDn;
            this.urlAttributes = attributes;
            this.urlScope = scope;
            this.urlFilter = filter;
        }

        public String getScheme() {
            return this.urlScheme;
        }

        public String getHostname() {
            return this.urlHostname;
        }

        public int getPort() {
            if (this.urlPort == -1) {
                return "ldaps".equals(this.urlScheme) ? 636 : 389;
            }
            return this.urlPort;
        }

        public boolean isDefaultPort() {
            return this.urlPort == -1;
        }

        public String getBaseDn() {
            return this.urlBaseDn == null ? DEFAULT_BASE_DN : this.urlBaseDn;
        }

        public boolean isDefaultBaseDn() {
            return this.urlBaseDn == null;
        }

        public String[] getAttributes() {
            return this.urlAttributes == null ? DEFAULT_ATTRIBUTES : this.urlAttributes;
        }

        public boolean isDefaultAttributes() {
            return this.urlAttributes == null;
        }

        public SearchScope getScope() {
            return this.urlScope == null ? DEFAULT_SCOPE : this.urlScope;
        }

        public boolean isDefaultScope() {
            return this.urlScope == null;
        }

        public SearchFilter getFilter() {
            return this.urlFilter == null ? DEFAULT_FILTER : this.urlFilter;
        }

        public boolean isDefaultFilter() {
            return this.urlFilter == null;
        }

        public String getUrl() {
            StringBuilder sb = new StringBuilder(this.urlScheme).append("://");
            String hostname = this.getHostname();
            if (hostname != null) {
                if (hostname.contains(":")) {
                    sb.append("[").append(hostname).append("]");
                } else {
                    sb.append(hostname);
                }
            }
            sb.append(":").append(this.getPort());
            sb.append("/").append(LdapUtils.percentEncode(this.getBaseDn()));
            sb.append("?");
            String[] attrs = this.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                sb.append(attrs[i]);
                if (i + 1 >= attrs.length) continue;
                sb.append(",");
            }
            sb.append("?");
            SearchScope scope = this.getScope();
            if (SearchScope.OBJECT == scope) {
                sb.append("base");
            } else if (SearchScope.ONELEVEL == scope) {
                sb.append("one");
            } else if (SearchScope.SUBTREE == scope) {
                sb.append("sub");
            }
            sb.append("?").append(LdapUtils.percentEncode(this.getFilter().format()));
            return sb.toString();
        }

        public String getHostnameWithPort() {
            return String.format("%s:%s", this.getHostname(), this.getPort());
        }

        public String getHostnameWithSchemeAndPort() {
            return String.format("%s://%s:%s", this.getScheme(), this.getHostname(), this.getPort());
        }

        public String toString() {
            return String.format("[%s@%d::scheme=%s, hostname=%s, port=%s, baseDn=%s, attributes=%s, scope=%s, filter=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.urlScheme, this.urlHostname, this.urlPort, this.urlBaseDn, Arrays.toString(this.urlAttributes), this.urlScope, this.urlFilter});
        }
    }
}

