/*
 * Decompiled with CFR 0.152.
 */
package com.rfksystems.blake2b;

import com.rfksystems.blake2b.ArrayUtils;
import com.rfksystems.blake2b.ByteUtils;
import com.rfksystems.blake2b.Const;

public class Blake2b {
    public static final String BLAKE2_B_160 = "BLAKE2B-160";
    public static final String BLAKE2_B_256 = "BLAKE2B-256";
    public static final String BLAKE2_B_384 = "BLAKE2B-384";
    public static final String BLAKE2_B_512 = "BLAKE2B-512";
    private int digestSize = 64;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private final long[] internalState = new long[16];
    private long[] chainValue = null;
    private long t0 = 0L;
    private long t1 = 0L;
    private long f0 = 0L;

    public Blake2b() {
        this(512);
    }

    public Blake2b(Blake2b digest) {
        this.bufferPos = digest.bufferPos;
        this.buffer = ArrayUtils.cloneByteArray(digest.buffer);
        this.keyLength = digest.keyLength;
        this.key = ArrayUtils.cloneByteArray(digest.key);
        this.digestSize = digest.digestSize;
        this.chainValue = ArrayUtils.cloneByteArray(digest.chainValue);
        this.personalization = ArrayUtils.cloneByteArray(digest.personalization);
        this.salt = ArrayUtils.cloneByteArray(digest.salt);
        this.t0 = digest.t0;
        this.t1 = digest.t1;
        this.f0 = digest.f0;
    }

    public Blake2b(int digestSize) {
        if (digestSize != 160 && digestSize != 256 && digestSize != 384 && digestSize != 512) {
            throw new IllegalArgumentException("Blake2b digest restricted to one of [160, 256, 384, 512]");
        }
        this.buffer = new byte[128];
        this.keyLength = 0;
        this.digestSize = digestSize / 8;
        this.init();
    }

    public Blake2b(byte[] key) {
        this.buffer = new byte[128];
        if (null != key) {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            if (64 < key.length) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 128;
        }
        this.digestSize = 64;
        this.init();
    }

    public Blake2b(byte[] key, int digestSize, byte[] salt, byte[] personalization) {
        this.buffer = new byte[128];
        if (digestSize < 1 || digestSize > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.digestSize = digestSize;
        if (salt != null) {
            if (salt.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.salt = new byte[16];
            System.arraycopy(salt, 0, this.salt, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.personalization = new byte[16];
            System.arraycopy(personalization, 0, this.personalization, 0, personalization.length);
        }
        if (key != null) {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 128;
        }
        this.init();
    }

    public void update(byte b) {
        int remainingLength = 128 - this.bufferPos;
        if (remainingLength == 0) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
            this.compress(this.buffer, 0);
            ArrayUtils.fillByteArray(this.buffer, (byte)0);
            this.buffer[0] = b;
            this.bufferPos = 1;
        } else {
            this.buffer[this.bufferPos] = b;
            ++this.bufferPos;
        }
    }

    public void update(byte[] message, int offset, int len) {
        int messagePos;
        if (null == message || 0 == len) {
            return;
        }
        int remainingLength = 0;
        if (0 != this.bufferPos) {
            remainingLength = 128 - this.bufferPos;
            if (remainingLength < len) {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, remainingLength);
                this.t0 += 128L;
                if (0L == this.t0) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                ArrayUtils.fillByteArray(this.buffer, (byte)0);
            } else {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, len);
                this.bufferPos += len;
                return;
            }
        }
        int blockWiseLastPos = offset + len - 128;
        for (messagePos = offset + remainingLength; messagePos < blockWiseLastPos; messagePos += 128) {
            this.t0 += 128L;
            if (0L == this.t0) {
                ++this.t1;
            }
            this.compress(message, messagePos);
        }
        System.arraycopy(message, messagePos, this.buffer, 0, offset + len - messagePos);
        this.bufferPos += offset + len - messagePos;
    }

    public int digest(byte[] out, int outOffset) {
        this.f0 = -1L;
        this.t0 += (long)this.bufferPos;
        if (0 < this.bufferPos && 0L == this.t0) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        ArrayUtils.fillByteArray(this.buffer, (byte)0);
        ArrayUtils.fillByteArray(this.internalState, 0L);
        for (int i = 0; i < this.chainValue.length && i * 8 < this.digestSize; ++i) {
            byte[] bytes = ByteUtils.long2bytes(this.chainValue[i]);
            if (i * 8 < this.digestSize - 8) {
                System.arraycopy(bytes, 0, out, outOffset + i * 8, 8);
                continue;
            }
            System.arraycopy(bytes, 0, out, outOffset + i * 8, this.digestSize - i * 8);
        }
        ArrayUtils.fillByteArray(this.chainValue, 0L);
        this.reset();
        return this.digestSize;
    }

    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0L;
        this.t0 = 0L;
        this.t1 = 0L;
        this.chainValue = null;
        ArrayUtils.fillByteArray(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 128;
        }
        this.init();
    }

    public int getDigestSize() {
        return this.digestSize;
    }

    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (null != this.key) {
            ArrayUtils.fillByteArray(this.key, (byte)0);
            ArrayUtils.fillByteArray(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (null != this.salt) {
            ArrayUtils.fillByteArray(this.salt, (byte)0);
        }
    }

    private void init() {
        if (null == this.chainValue) {
            long[] newChainValue = new long[8];
            newChainValue[0] = Const.BLAKE2B_IV[0] ^ (long)(this.digestSize | this.keyLength << 8 | 0x1010000);
            newChainValue[1] = Const.BLAKE2B_IV[1];
            newChainValue[2] = Const.BLAKE2B_IV[2];
            newChainValue[3] = Const.BLAKE2B_IV[3];
            newChainValue[4] = Const.BLAKE2B_IV[4];
            newChainValue[5] = Const.BLAKE2B_IV[5];
            if (null != this.salt) {
                newChainValue[4] = newChainValue[4] ^ ByteUtils.bytes2long(this.salt, 0);
                newChainValue[5] = newChainValue[5] ^ ByteUtils.bytes2long(this.salt, 8);
            }
            newChainValue[6] = Const.BLAKE2B_IV[6];
            newChainValue[7] = Const.BLAKE2B_IV[7];
            if (null != this.personalization) {
                newChainValue[6] = newChainValue[6] ^ ByteUtils.bytes2long(this.personalization, 0);
                newChainValue[7] = newChainValue[7] ^ ByteUtils.bytes2long(this.personalization, 8);
            }
            this.chainValue = newChainValue;
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(Const.BLAKE2B_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ Const.BLAKE2B_IV[4];
        this.internalState[13] = this.t1 ^ Const.BLAKE2B_IV[5];
        this.internalState[14] = this.f0 ^ Const.BLAKE2B_IV[6];
        this.internalState[15] = Const.BLAKE2B_IV[7];
    }

    private void compress(byte[] message, int messagePos) {
        this.initializeInternalState();
        long[] m = new long[16];
        for (int j = 0; j < 16; ++j) {
            m[j] = ByteUtils.bytes2long(message, messagePos + j * 8);
        }
        for (int round = 0; round < 12; ++round) {
            this.G(m[Const.BLAKE2B_SIGMA[round][0]], m[Const.BLAKE2B_SIGMA[round][1]], 0, 4, 8, 12);
            this.G(m[Const.BLAKE2B_SIGMA[round][2]], m[Const.BLAKE2B_SIGMA[round][3]], 1, 5, 9, 13);
            this.G(m[Const.BLAKE2B_SIGMA[round][4]], m[Const.BLAKE2B_SIGMA[round][5]], 2, 6, 10, 14);
            this.G(m[Const.BLAKE2B_SIGMA[round][6]], m[Const.BLAKE2B_SIGMA[round][7]], 3, 7, 11, 15);
            this.G(m[Const.BLAKE2B_SIGMA[round][8]], m[Const.BLAKE2B_SIGMA[round][9]], 0, 5, 10, 15);
            this.G(m[Const.BLAKE2B_SIGMA[round][10]], m[Const.BLAKE2B_SIGMA[round][11]], 1, 6, 11, 12);
            this.G(m[Const.BLAKE2B_SIGMA[round][12]], m[Const.BLAKE2B_SIGMA[round][13]], 2, 7, 8, 13);
            this.G(m[Const.BLAKE2B_SIGMA[round][14]], m[Const.BLAKE2B_SIGMA[round][15]], 3, 4, 9, 14);
        }
        for (int offset = 0; offset < this.chainValue.length; ++offset) {
            this.chainValue[offset] = this.chainValue[offset] ^ this.internalState[offset] ^ this.internalState[offset + 8];
        }
    }

    private void G(long m1, long m2, int posA, int posB, int posC, int posD) {
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m1;
        this.internalState[posD] = ByteUtils.rotr64(this.internalState[posD] ^ this.internalState[posA], 32);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = ByteUtils.rotr64(this.internalState[posB] ^ this.internalState[posC], 24);
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m2;
        this.internalState[posD] = ByteUtils.rotr64(this.internalState[posD] ^ this.internalState[posA], 16);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = ByteUtils.rotr64(this.internalState[posB] ^ this.internalState[posC], 63);
    }
}

