import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateDistributionRequestFilterSensitiveLog, UpdateDistributionResultFilterSensitiveLog, } from "../models/models_2";
import { de_UpdateDistributionCommand, se_UpdateDistributionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class UpdateDistributionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "UpdateDistribution", {})
    .n("CloudFrontClient", "UpdateDistributionCommand")
    .f(UpdateDistributionRequestFilterSensitiveLog, UpdateDistributionResultFilterSensitiveLog)
    .ser(se_UpdateDistributionCommand)
    .de(de_UpdateDistributionCommand)
    .build() {
}
