import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdateStreamingDistributionCommand, se_UpdateStreamingDistributionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class UpdateStreamingDistributionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "UpdateStreamingDistribution", {})
    .n("CloudFrontClient", "UpdateStreamingDistributionCommand")
    .f(void 0, void 0)
    .ser(se_UpdateStreamingDistributionCommand)
    .de(de_UpdateStreamingDistributionCommand)
    .build() {
}
