import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { Uint8ArrayBlobAdapter } from "@smithy/util-stream";
import {
  CloudFrontClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFrontClient";
import { GetFunctionRequest, GetFunctionResult } from "../models/models_1";
export { __MetadataBearer };
export { $Command };
export interface GetFunctionCommandInput extends GetFunctionRequest {}
export type GetFunctionCommandOutputType = Pick<
  GetFunctionResult,
  Exclude<keyof GetFunctionResult, "FunctionCode">
> & {
  FunctionCode?: Uint8ArrayBlobAdapter;
};
export interface GetFunctionCommandOutput
  extends GetFunctionCommandOutputType,
    __MetadataBearer {}
declare const GetFunctionCommand_base: {
  new (
    input: GetFunctionCommandInput
  ): import("@smithy/smithy-client").CommandImpl<
    GetFunctionCommandInput,
    GetFunctionCommandOutput,
    CloudFrontClientResolvedConfig,
    ServiceInputTypes,
    ServiceOutputTypes
  >;
  new (
    input: GetFunctionCommandInput
  ): import("@smithy/smithy-client").CommandImpl<
    GetFunctionCommandInput,
    GetFunctionCommandOutput,
    CloudFrontClientResolvedConfig,
    ServiceInputTypes,
    ServiceOutputTypes
  >;
  getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
export declare class GetFunctionCommand extends GetFunctionCommand_base {
  protected static __types: {
    api: {
      input: GetFunctionRequest;
      output: GetFunctionResult;
    };
    sdk: {
      input: GetFunctionCommandInput;
      output: GetFunctionCommandOutput;
    };
  };
}
