import type { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFrontServiceException as __BaseException } from "./CloudFrontServiceException";
/**
 * <p>Access denied.</p>
 * @public
 */
export declare class AccessDenied extends __BaseException {
    readonly name: "AccessDenied";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AccessDenied, __BaseException>);
}
/**
 * <p>The update contains modifications that are not allowed.</p>
 * @public
 */
export declare class IllegalUpdate extends __BaseException {
    readonly name: "IllegalUpdate";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<IllegalUpdate, __BaseException>);
}
/**
 * <p>An argument is invalid.</p>
 * @public
 */
export declare class InvalidArgument extends __BaseException {
    readonly name: "InvalidArgument";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidArgument, __BaseException>);
}
/**
 * <p>The specified distribution does not exist.</p>
 * @public
 */
export declare class NoSuchDistribution extends __BaseException {
    readonly name: "NoSuchDistribution";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchDistribution, __BaseException>);
}
/**
 * <p>Your request contains more CNAMEs than are allowed per distribution.</p>
 * @public
 */
export declare class TooManyDistributionCNAMEs extends __BaseException {
    readonly name: "TooManyDistributionCNAMEs";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionCNAMEs, __BaseException>);
}
/**
 * <p>The entity limit has been exceeded.</p>
 * @public
 */
export declare class EntityLimitExceeded extends __BaseException {
    readonly name: "EntityLimitExceeded";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EntityLimitExceeded, __BaseException>);
}
/**
 * <p>The entity was not found.</p>
 * @public
 */
export declare class EntityNotFound extends __BaseException {
    readonly name: "EntityNotFound";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EntityNotFound, __BaseException>);
}
/**
 * <p>The <code>If-Match</code> version is missing or not valid.</p>
 * @public
 */
export declare class InvalidIfMatchVersion extends __BaseException {
    readonly name: "InvalidIfMatchVersion";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidIfMatchVersion, __BaseException>);
}
/**
 * <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
 * @public
 */
export declare class PreconditionFailed extends __BaseException {
    readonly name: "PreconditionFailed";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<PreconditionFailed, __BaseException>);
}
/**
 * <p>Invalidation batch specified is too large.</p>
 * @public
 */
export declare class BatchTooLarge extends __BaseException {
    readonly name: "BatchTooLarge";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BatchTooLarge, __BaseException>);
}
/**
 * <p>A cache policy with this name already exists. You must provide a unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>
 * @public
 */
export declare class CachePolicyAlreadyExists extends __BaseException {
    readonly name: "CachePolicyAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CachePolicyAlreadyExists, __BaseException>);
}
/**
 * <p>Cannot delete the cache policy because it is attached to one or more cache behaviors.</p>
 * @public
 */
export declare class CachePolicyInUse extends __BaseException {
    readonly name: "CachePolicyInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CachePolicyInUse, __BaseException>);
}
/**
 * <p>You can't change the value of a public key.</p>
 * @public
 */
export declare class CannotChangeImmutablePublicKeyFields extends __BaseException {
    readonly name: "CannotChangeImmutablePublicKeyFields";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CannotChangeImmutablePublicKeyFields, __BaseException>);
}
/**
 * <p>The entity cannot be deleted while it is in use.</p>
 * @public
 */
export declare class CannotDeleteEntityWhileInUse extends __BaseException {
    readonly name: "CannotDeleteEntityWhileInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CannotDeleteEntityWhileInUse, __BaseException>);
}
/**
 * <p>The entity cannot be updated while it is in use.</p>
 * @public
 */
export declare class CannotUpdateEntityWhileInUse extends __BaseException {
    readonly name: "CannotUpdateEntityWhileInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CannotUpdateEntityWhileInUse, __BaseException>);
}
/**
 * <p>The CNAME specified is already defined for CloudFront.</p>
 * @public
 */
export declare class CNAMEAlreadyExists extends __BaseException {
    readonly name: "CNAMEAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CNAMEAlreadyExists, __BaseException>);
}
/**
 * <p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>
 * @public
 */
export declare class DistributionAlreadyExists extends __BaseException {
    readonly name: "DistributionAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<DistributionAlreadyExists, __BaseException>);
}
/**
 * <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
 * @public
 */
export declare class IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior extends __BaseException {
    readonly name: "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior, __BaseException>);
}
/**
 * <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
 * @public
 */
export declare class InconsistentQuantities extends __BaseException {
    readonly name: "InconsistentQuantities";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InconsistentQuantities, __BaseException>);
}
/**
 * <p>The default root object file name is too big or contains an invalid character.</p>
 * @public
 */
export declare class InvalidDefaultRootObject extends __BaseException {
    readonly name: "InvalidDefaultRootObject";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidDefaultRootObject, __BaseException>);
}
/**
 * <p>An invalid error code was specified.</p>
 * @public
 */
export declare class InvalidErrorCode extends __BaseException {
    readonly name: "InvalidErrorCode";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidErrorCode, __BaseException>);
}
/**
 * <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
 * @public
 */
export declare class InvalidForwardCookies extends __BaseException {
    readonly name: "InvalidForwardCookies";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidForwardCookies, __BaseException>);
}
/**
 * <p>A CloudFront function association is invalid.</p>
 * @public
 */
export declare class InvalidFunctionAssociation extends __BaseException {
    readonly name: "InvalidFunctionAssociation";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidFunctionAssociation, __BaseException>);
}
/**
 * <p>The specified geo restriction parameter is not valid.</p>
 * @public
 */
export declare class InvalidGeoRestrictionParameter extends __BaseException {
    readonly name: "InvalidGeoRestrictionParameter";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidGeoRestrictionParameter, __BaseException>);
}
/**
 * <p>The headers specified are not valid for an Amazon S3 origin.</p>
 * @public
 */
export declare class InvalidHeadersForS3Origin extends __BaseException {
    readonly name: "InvalidHeadersForS3Origin";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidHeadersForS3Origin, __BaseException>);
}
/**
 * <p>The specified Lambda@Edge function association is invalid.</p>
 * @public
 */
export declare class InvalidLambdaFunctionAssociation extends __BaseException {
    readonly name: "InvalidLambdaFunctionAssociation";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidLambdaFunctionAssociation, __BaseException>);
}
/**
 * <p>The location code specified is not valid.</p>
 * @public
 */
export declare class InvalidLocationCode extends __BaseException {
    readonly name: "InvalidLocationCode";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidLocationCode, __BaseException>);
}
/**
 * <p>The minimum protocol version specified is not valid.</p>
 * @public
 */
export declare class InvalidMinimumProtocolVersion extends __BaseException {
    readonly name: "InvalidMinimumProtocolVersion";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidMinimumProtocolVersion, __BaseException>);
}
/**
 * <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
 * @public
 */
export declare class InvalidOrigin extends __BaseException {
    readonly name: "InvalidOrigin";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidOrigin, __BaseException>);
}
/**
 * <p>The origin access control is not valid.</p>
 * @public
 */
export declare class InvalidOriginAccessControl extends __BaseException {
    readonly name: "InvalidOriginAccessControl";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidOriginAccessControl, __BaseException>);
}
/**
 * <p>The origin access identity is not valid or doesn't exist.</p>
 * @public
 */
export declare class InvalidOriginAccessIdentity extends __BaseException {
    readonly name: "InvalidOriginAccessIdentity";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidOriginAccessIdentity, __BaseException>);
}
/**
 * <p>The keep alive timeout specified for the origin is not valid.</p>
 * @public
 */
export declare class InvalidOriginKeepaliveTimeout extends __BaseException {
    readonly name: "InvalidOriginKeepaliveTimeout";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidOriginKeepaliveTimeout, __BaseException>);
}
/**
 * <p>The read timeout specified for the origin is not valid.</p>
 * @public
 */
export declare class InvalidOriginReadTimeout extends __BaseException {
    readonly name: "InvalidOriginReadTimeout";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidOriginReadTimeout, __BaseException>);
}
/**
 * <p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support Server Name Indication (SNI).</p>
 * @public
 */
export declare class InvalidProtocolSettings extends __BaseException {
    readonly name: "InvalidProtocolSettings";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidProtocolSettings, __BaseException>);
}
/**
 * <p>The query string parameters specified are not valid.</p>
 * @public
 */
export declare class InvalidQueryStringParameters extends __BaseException {
    readonly name: "InvalidQueryStringParameters";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidQueryStringParameters, __BaseException>);
}
/**
 * <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
 * @public
 */
export declare class InvalidRelativePath extends __BaseException {
    readonly name: "InvalidRelativePath";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidRelativePath, __BaseException>);
}
/**
 * <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>
 * @public
 */
export declare class InvalidRequiredProtocol extends __BaseException {
    readonly name: "InvalidRequiredProtocol";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidRequiredProtocol, __BaseException>);
}
/**
 * <p>A response code is not valid.</p>
 * @public
 */
export declare class InvalidResponseCode extends __BaseException {
    readonly name: "InvalidResponseCode";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidResponseCode, __BaseException>);
}
/**
 * <p>The TTL order specified is not valid.</p>
 * @public
 */
export declare class InvalidTTLOrder extends __BaseException {
    readonly name: "InvalidTTLOrder";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidTTLOrder, __BaseException>);
}
/**
 * <p>A viewer certificate specified is not valid.</p>
 * @public
 */
export declare class InvalidViewerCertificate extends __BaseException {
    readonly name: "InvalidViewerCertificate";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidViewerCertificate, __BaseException>);
}
/**
 * <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
 * @public
 */
export declare class InvalidWebACLId extends __BaseException {
    readonly name: "InvalidWebACLId";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidWebACLId, __BaseException>);
}
/**
 * <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
 * @public
 */
export declare class MissingBody extends __BaseException {
    readonly name: "MissingBody";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<MissingBody, __BaseException>);
}
/**
 * <p>The cache policy does not exist.</p>
 * @public
 */
export declare class NoSuchCachePolicy extends __BaseException {
    readonly name: "NoSuchCachePolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchCachePolicy, __BaseException>);
}
/**
 * <p>The specified configuration for field-level encryption doesn't exist.</p>
 * @public
 */
export declare class NoSuchFieldLevelEncryptionConfig extends __BaseException {
    readonly name: "NoSuchFieldLevelEncryptionConfig";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchFieldLevelEncryptionConfig, __BaseException>);
}
/**
 * <p>No origin exists with the specified <code>Origin Id</code>.</p>
 * @public
 */
export declare class NoSuchOrigin extends __BaseException {
    readonly name: "NoSuchOrigin";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchOrigin, __BaseException>);
}
/**
 * <p>The origin request policy does not exist.</p>
 * @public
 */
export declare class NoSuchOriginRequestPolicy extends __BaseException {
    readonly name: "NoSuchOriginRequestPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchOriginRequestPolicy, __BaseException>);
}
/**
 * <p>The real-time log configuration does not exist.</p>
 * @public
 */
export declare class NoSuchRealtimeLogConfig extends __BaseException {
    readonly name: "NoSuchRealtimeLogConfig";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchRealtimeLogConfig, __BaseException>);
}
/**
 * <p>The response headers policy does not exist.</p>
 * @public
 */
export declare class NoSuchResponseHeadersPolicy extends __BaseException {
    readonly name: "NoSuchResponseHeadersPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchResponseHeadersPolicy, __BaseException>);
}
/**
 * <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
 * @public
 */
export declare class RealtimeLogConfigOwnerMismatch extends __BaseException {
    readonly name: "RealtimeLogConfigOwnerMismatch";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<RealtimeLogConfigOwnerMismatch, __BaseException>);
}
/**
 * <p>You cannot create more cache behaviors for the distribution.</p>
 * @public
 */
export declare class TooManyCacheBehaviors extends __BaseException {
    readonly name: "TooManyCacheBehaviors";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCacheBehaviors, __BaseException>);
}
/**
 * <p>You cannot create anymore custom SSL/TLS certificates.</p>
 * @public
 */
export declare class TooManyCertificates extends __BaseException {
    readonly name: "TooManyCertificates";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCertificates, __BaseException>);
}
/**
 * <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
 * @public
 */
export declare class TooManyCookieNamesInWhiteList extends __BaseException {
    readonly name: "TooManyCookieNamesInWhiteList";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCookieNamesInWhiteList, __BaseException>);
}
/**
 * <p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>
 * @public
 */
export declare class TooManyDistributions extends __BaseException {
    readonly name: "TooManyDistributions";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributions, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToCachePolicy extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToCachePolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToCachePolicy, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToFieldLevelEncryptionConfig extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToFieldLevelEncryptionConfig, __BaseException>);
}
/**
 * <p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToKeyGroup extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToKeyGroup";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToKeyGroup, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified origin access control.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToOriginAccessControl extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToOriginAccessControl";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToOriginAccessControl, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToOriginRequestPolicy extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToOriginRequestPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToOriginRequestPolicy, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified response headers policy.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsAssociatedToResponseHeadersPolicy extends __BaseException {
    readonly name: "TooManyDistributionsAssociatedToResponseHeadersPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsAssociatedToResponseHeadersPolicy, __BaseException>);
}
/**
 * <p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyDistributionsWithFunctionAssociations extends __BaseException {
    readonly name: "TooManyDistributionsWithFunctionAssociations";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsWithFunctionAssociations, __BaseException>);
}
/**
 * <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>
 * @public
 */
export declare class TooManyDistributionsWithLambdaAssociations extends __BaseException {
    readonly name: "TooManyDistributionsWithLambdaAssociations";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsWithLambdaAssociations, __BaseException>);
}
/**
 * <p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>
 * @public
 */
export declare class TooManyDistributionsWithSingleFunctionARN extends __BaseException {
    readonly name: "TooManyDistributionsWithSingleFunctionARN";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyDistributionsWithSingleFunctionARN, __BaseException>);
}
/**
 * <p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyFunctionAssociations extends __BaseException {
    readonly name: "TooManyFunctionAssociations";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFunctionAssociations, __BaseException>);
}
/**
 * <p>Your request contains too many headers in forwarded values.</p>
 * @public
 */
export declare class TooManyHeadersInForwardedValues extends __BaseException {
    readonly name: "TooManyHeadersInForwardedValues";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyHeadersInForwardedValues, __BaseException>);
}
/**
 * <p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyKeyGroupsAssociatedToDistribution extends __BaseException {
    readonly name: "TooManyKeyGroupsAssociatedToDistribution";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyKeyGroupsAssociatedToDistribution, __BaseException>);
}
/**
 * <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
 * @public
 */
export declare class TooManyLambdaFunctionAssociations extends __BaseException {
    readonly name: "TooManyLambdaFunctionAssociations";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyLambdaFunctionAssociations, __BaseException>);
}
/**
 * <p>Your request contains too many origin custom headers.</p>
 * @public
 */
export declare class TooManyOriginCustomHeaders extends __BaseException {
    readonly name: "TooManyOriginCustomHeaders";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyOriginCustomHeaders, __BaseException>);
}
/**
 * <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
 * @public
 */
export declare class TooManyOriginGroupsPerDistribution extends __BaseException {
    readonly name: "TooManyOriginGroupsPerDistribution";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyOriginGroupsPerDistribution, __BaseException>);
}
/**
 * <p>You cannot create more origins for the distribution.</p>
 * @public
 */
export declare class TooManyOrigins extends __BaseException {
    readonly name: "TooManyOrigins";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyOrigins, __BaseException>);
}
/**
 * <p>Your request contains too many query string parameters.</p>
 * @public
 */
export declare class TooManyQueryStringParameters extends __BaseException {
    readonly name: "TooManyQueryStringParameters";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyQueryStringParameters, __BaseException>);
}
/**
 * <p>Your request contains more trusted signers than are allowed per distribution.</p>
 * @public
 */
export declare class TooManyTrustedSigners extends __BaseException {
    readonly name: "TooManyTrustedSigners";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyTrustedSigners, __BaseException>);
}
/**
 * <p>The specified key group does not exist.</p>
 * @public
 */
export declare class TrustedKeyGroupDoesNotExist extends __BaseException {
    readonly name: "TrustedKeyGroupDoesNotExist";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TrustedKeyGroupDoesNotExist, __BaseException>);
}
/**
 * <p>One or more of your trusted signers don't exist.</p>
 * @public
 */
export declare class TrustedSignerDoesNotExist extends __BaseException {
    readonly name: "TrustedSignerDoesNotExist";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TrustedSignerDoesNotExist, __BaseException>);
}
/**
 * <p>The entity already exists. You must provide a unique entity.</p>
 * @public
 */
export declare class EntityAlreadyExists extends __BaseException {
    readonly name: "EntityAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EntityAlreadyExists, __BaseException>);
}
/**
 * <p>The tagging specified is not valid.</p>
 * @public
 */
export declare class InvalidTagging extends __BaseException {
    readonly name: "InvalidTagging";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidTagging, __BaseException>);
}
/**
 * <p>This operation is not supported in this Amazon Web Services Region.</p>
 * @public
 */
export declare class UnsupportedOperation extends __BaseException {
    readonly name: "UnsupportedOperation";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UnsupportedOperation, __BaseException>);
}
/**
 * <p>You have reached the maximum number of cache policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyCachePolicies extends __BaseException {
    readonly name: "TooManyCachePolicies";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCachePolicies, __BaseException>);
}
/**
 * <p>The number of cookies in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyCookiesInCachePolicy extends __BaseException {
    readonly name: "TooManyCookiesInCachePolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCookiesInCachePolicy, __BaseException>);
}
/**
 * <p>The number of headers in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyHeadersInCachePolicy extends __BaseException {
    readonly name: "TooManyHeadersInCachePolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyHeadersInCachePolicy, __BaseException>);
}
/**
 * <p>The number of query strings in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyQueryStringsInCachePolicy extends __BaseException {
    readonly name: "TooManyQueryStringsInCachePolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyQueryStringsInCachePolicy, __BaseException>);
}
/**
 * <p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
 * @public
 */
export declare class CloudFrontOriginAccessIdentityAlreadyExists extends __BaseException {
    readonly name: "CloudFrontOriginAccessIdentityAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CloudFrontOriginAccessIdentityAlreadyExists, __BaseException>);
}
/**
 * <p>Processing your request would cause you to exceed the maximum number of origin access identities allowed.</p>
 * @public
 */
export declare class TooManyCloudFrontOriginAccessIdentities extends __BaseException {
    readonly name: "TooManyCloudFrontOriginAccessIdentities";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCloudFrontOriginAccessIdentities, __BaseException>);
}
/**
 * <p>The entity size limit was exceeded.</p>
 * @public
 */
export declare class EntitySizeLimitExceeded extends __BaseException {
    readonly name: "EntitySizeLimitExceeded";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EntitySizeLimitExceeded, __BaseException>);
}
/**
 * <p>A continuous deployment policy with this configuration already exists.</p>
 * @public
 */
export declare class ContinuousDeploymentPolicyAlreadyExists extends __BaseException {
    readonly name: "ContinuousDeploymentPolicyAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ContinuousDeploymentPolicyAlreadyExists, __BaseException>);
}
/**
 * <p>A continuous deployment policy for this staging distribution already exists.</p>
 * @public
 */
export declare class StagingDistributionInUse extends __BaseException {
    readonly name: "StagingDistributionInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<StagingDistributionInUse, __BaseException>);
}
/**
 * <p>You have reached the maximum number of continuous deployment policies for this Amazon Web Services account.</p>
 * @public
 */
export declare class TooManyContinuousDeploymentPolicies extends __BaseException {
    readonly name: "TooManyContinuousDeploymentPolicies";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyContinuousDeploymentPolicies, __BaseException>);
}
/**
 * <p>You cannot delete a continuous deployment policy that is associated with a primary distribution.</p>
 * @public
 */
export declare class ContinuousDeploymentPolicyInUse extends __BaseException {
    readonly name: "ContinuousDeploymentPolicyInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ContinuousDeploymentPolicyInUse, __BaseException>);
}
/**
 * <p>An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).</p>
 * @public
 */
export declare class IllegalOriginAccessConfiguration extends __BaseException {
    readonly name: "IllegalOriginAccessConfiguration";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<IllegalOriginAccessConfiguration, __BaseException>);
}
/**
 * <p>An origin access control is associated with an origin whose domain name is not supported.</p>
 * @public
 */
export declare class InvalidDomainNameForOriginAccessControl extends __BaseException {
    readonly name: "InvalidDomainNameForOriginAccessControl";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidDomainNameForOriginAccessControl, __BaseException>);
}
/**
 * <p>The continuous deployment policy doesn't exist.</p>
 * @public
 */
export declare class NoSuchContinuousDeploymentPolicy extends __BaseException {
    readonly name: "NoSuchContinuousDeploymentPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchContinuousDeploymentPolicy, __BaseException>);
}
/**
 * <p>The specified CloudFront resource can't be associated.</p>
 * @public
 */
export declare class InvalidAssociation extends __BaseException {
    readonly name: "InvalidAssociation";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidAssociation, __BaseException>);
}
/**
 * <p>The specified configuration for field-level encryption already exists.</p>
 * @public
 */
export declare class FieldLevelEncryptionConfigAlreadyExists extends __BaseException {
    readonly name: "FieldLevelEncryptionConfigAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FieldLevelEncryptionConfigAlreadyExists, __BaseException>);
}
/**
 * <p>The specified profile for field-level encryption doesn't exist.</p>
 * @public
 */
export declare class NoSuchFieldLevelEncryptionProfile extends __BaseException {
    readonly name: "NoSuchFieldLevelEncryptionProfile";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchFieldLevelEncryptionProfile, __BaseException>);
}
/**
 * <p>No profile specified for the field-level encryption query argument.</p>
 * @public
 */
export declare class QueryArgProfileEmpty extends __BaseException {
    readonly name: "QueryArgProfileEmpty";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<QueryArgProfileEmpty, __BaseException>);
}
/**
 * <p>The maximum number of configurations for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionConfigs extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionConfigs";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionConfigs, __BaseException>);
}
/**
 * <p>The maximum number of content type profiles for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionContentTypeProfiles extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionContentTypeProfiles";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionContentTypeProfiles, __BaseException>);
}
/**
 * <p>The maximum number of query arg profiles for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionQueryArgProfiles extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionQueryArgProfiles";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionQueryArgProfiles, __BaseException>);
}
/**
 * <p>The specified profile for field-level encryption already exists.</p>
 * @public
 */
export declare class FieldLevelEncryptionProfileAlreadyExists extends __BaseException {
    readonly name: "FieldLevelEncryptionProfileAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FieldLevelEncryptionProfileAlreadyExists, __BaseException>);
}
/**
 * <p>The maximum size of a profile for field-level encryption was exceeded.</p>
 * @public
 */
export declare class FieldLevelEncryptionProfileSizeExceeded extends __BaseException {
    readonly name: "FieldLevelEncryptionProfileSizeExceeded";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FieldLevelEncryptionProfileSizeExceeded, __BaseException>);
}
/**
 * <p>The specified public key doesn't exist.</p>
 * @public
 */
export declare class NoSuchPublicKey extends __BaseException {
    readonly name: "NoSuchPublicKey";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchPublicKey, __BaseException>);
}
/**
 * <p>The maximum number of encryption entities for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionEncryptionEntities extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionEncryptionEntities";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionEncryptionEntities, __BaseException>);
}
/**
 * <p>The maximum number of field patterns for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionFieldPatterns extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionFieldPatterns";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionFieldPatterns, __BaseException>);
}
/**
 * <p>The maximum number of profiles for field-level encryption have been created.</p>
 * @public
 */
export declare class TooManyFieldLevelEncryptionProfiles extends __BaseException {
    readonly name: "TooManyFieldLevelEncryptionProfiles";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFieldLevelEncryptionProfiles, __BaseException>);
}
/**
 * <p>A function with the same name already exists in this Amazon Web Services account. To create a function, you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.</p>
 * @public
 */
export declare class FunctionAlreadyExists extends __BaseException {
    readonly name: "FunctionAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FunctionAlreadyExists, __BaseException>);
}
/**
 * <p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class FunctionSizeLimitExceeded extends __BaseException {
    readonly name: "FunctionSizeLimitExceeded";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FunctionSizeLimitExceeded, __BaseException>);
}
/**
 * <p>You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyFunctions extends __BaseException {
    readonly name: "TooManyFunctions";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyFunctions, __BaseException>);
}
/**
 * <p>You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation objects.</p>
 * @public
 */
export declare class TooManyInvalidationsInProgress extends __BaseException {
    readonly name: "TooManyInvalidationsInProgress";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyInvalidationsInProgress, __BaseException>);
}
/**
 * <p>A key group with this name already exists. You must provide a unique name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</p>
 * @public
 */
export declare class KeyGroupAlreadyExists extends __BaseException {
    readonly name: "KeyGroupAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KeyGroupAlreadyExists, __BaseException>);
}
/**
 * <p>You have reached the maximum number of key groups for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyKeyGroups extends __BaseException {
    readonly name: "TooManyKeyGroups";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyKeyGroups, __BaseException>);
}
/**
 * <p>The number of public keys in this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyPublicKeysInKeyGroup extends __BaseException {
    readonly name: "TooManyPublicKeysInKeyGroup";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyPublicKeysInKeyGroup, __BaseException>);
}
/**
 * <p>A monitoring subscription already exists for the specified distribution.</p>
 * @public
 */
export declare class MonitoringSubscriptionAlreadyExists extends __BaseException {
    readonly name: "MonitoringSubscriptionAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<MonitoringSubscriptionAlreadyExists, __BaseException>);
}
/**
 * <p>An origin access control with the specified parameters already exists.</p>
 * @public
 */
export declare class OriginAccessControlAlreadyExists extends __BaseException {
    readonly name: "OriginAccessControlAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<OriginAccessControlAlreadyExists, __BaseException>);
}
/**
 * <p>The number of origin access controls in your Amazon Web Services account exceeds the maximum allowed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyOriginAccessControls extends __BaseException {
    readonly name: "TooManyOriginAccessControls";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyOriginAccessControls, __BaseException>);
}
/**
 * <p>An origin request policy with this name already exists. You must provide a unique name. To modify an existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.</p>
 * @public
 */
export declare class OriginRequestPolicyAlreadyExists extends __BaseException {
    readonly name: "OriginRequestPolicyAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<OriginRequestPolicyAlreadyExists, __BaseException>);
}
/**
 * <p>The number of cookies in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyCookiesInOriginRequestPolicy extends __BaseException {
    readonly name: "TooManyCookiesInOriginRequestPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCookiesInOriginRequestPolicy, __BaseException>);
}
/**
 * <p>The number of headers in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyHeadersInOriginRequestPolicy extends __BaseException {
    readonly name: "TooManyHeadersInOriginRequestPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyHeadersInOriginRequestPolicy, __BaseException>);
}
/**
 * <p>You have reached the maximum number of origin request policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyOriginRequestPolicies extends __BaseException {
    readonly name: "TooManyOriginRequestPolicies";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyOriginRequestPolicies, __BaseException>);
}
/**
 * <p>The number of query strings in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyQueryStringsInOriginRequestPolicy extends __BaseException {
    readonly name: "TooManyQueryStringsInOriginRequestPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyQueryStringsInOriginRequestPolicy, __BaseException>);
}
/**
 * <p>The specified public key already exists.</p>
 * @public
 */
export declare class PublicKeyAlreadyExists extends __BaseException {
    readonly name: "PublicKeyAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<PublicKeyAlreadyExists, __BaseException>);
}
/**
 * <p>The maximum number of public keys for field-level encryption have been created. To create a new public key, delete one of the existing keys.</p>
 * @public
 */
export declare class TooManyPublicKeys extends __BaseException {
    readonly name: "TooManyPublicKeys";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyPublicKeys, __BaseException>);
}
/**
 * <p>A real-time log configuration with this name already exists. You must provide a unique name. To modify an existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.</p>
 * @public
 */
export declare class RealtimeLogConfigAlreadyExists extends __BaseException {
    readonly name: "RealtimeLogConfigAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<RealtimeLogConfigAlreadyExists, __BaseException>);
}
/**
 * <p>You have reached the maximum number of real-time log configurations for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyRealtimeLogConfigs extends __BaseException {
    readonly name: "TooManyRealtimeLogConfigs";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyRealtimeLogConfigs, __BaseException>);
}
/**
 * <p>A response headers policy with this name already exists. You must provide a unique name. To modify an existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.</p>
 * @public
 */
export declare class ResponseHeadersPolicyAlreadyExists extends __BaseException {
    readonly name: "ResponseHeadersPolicyAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResponseHeadersPolicyAlreadyExists, __BaseException>);
}
/**
 * <p>The length of the <code>Content-Security-Policy</code> header value in the response headers policy exceeds the maximum.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooLongCSPInResponseHeadersPolicy extends __BaseException {
    readonly name: "TooLongCSPInResponseHeadersPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooLongCSPInResponseHeadersPolicy, __BaseException>);
}
/**
 * <p>The number of custom headers in the response headers policy exceeds the maximum.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyCustomHeadersInResponseHeadersPolicy extends __BaseException {
    readonly name: "TooManyCustomHeadersInResponseHeadersPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyCustomHeadersInResponseHeadersPolicy, __BaseException>);
}
/**
 * <p>The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the maximum.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyRemoveHeadersInResponseHeadersPolicy extends __BaseException {
    readonly name: "TooManyRemoveHeadersInResponseHeadersPolicy";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyRemoveHeadersInResponseHeadersPolicy, __BaseException>);
}
/**
 * <p>You have reached the maximum number of response headers policies for this Amazon Web Services account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
 * @public
 */
export declare class TooManyResponseHeadersPolicies extends __BaseException {
    readonly name: "TooManyResponseHeadersPolicies";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyResponseHeadersPolicies, __BaseException>);
}
/**
 * <p>The caller reference you attempted to create the streaming distribution with is associated with another distribution</p>
 * @public
 */
export declare class StreamingDistributionAlreadyExists extends __BaseException {
    readonly name: "StreamingDistributionAlreadyExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<StreamingDistributionAlreadyExists, __BaseException>);
}
/**
 * <p>Your request contains more CNAMEs than are allowed per distribution.</p>
 * @public
 */
export declare class TooManyStreamingDistributionCNAMEs extends __BaseException {
    readonly name: "TooManyStreamingDistributionCNAMEs";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyStreamingDistributionCNAMEs, __BaseException>);
}
/**
 * <p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>
 * @public
 */
export declare class TooManyStreamingDistributions extends __BaseException {
    readonly name: "TooManyStreamingDistributions";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyStreamingDistributions, __BaseException>);
}
/**
 * <p>Deletion is not allowed for this entity.</p>
 * @public
 */
export declare class IllegalDelete extends __BaseException {
    readonly name: "IllegalDelete";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<IllegalDelete, __BaseException>);
}
/**
 * <p>The Origin Access Identity specified is already in use.</p>
 * @public
 */
export declare class CloudFrontOriginAccessIdentityInUse extends __BaseException {
    readonly name: "CloudFrontOriginAccessIdentityInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<CloudFrontOriginAccessIdentityInUse, __BaseException>);
}
/**
 * <p>The specified origin access identity does not exist.</p>
 * @public
 */
export declare class NoSuchCloudFrontOriginAccessIdentity extends __BaseException {
    readonly name: "NoSuchCloudFrontOriginAccessIdentity";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchCloudFrontOriginAccessIdentity, __BaseException>);
}
/**
 * <p>The specified CloudFront resource hasn't been disabled yet.</p>
 * @public
 */
export declare class ResourceNotDisabled extends __BaseException {
    readonly name: "ResourceNotDisabled";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotDisabled, __BaseException>);
}
/**
 * <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
 * @public
 */
export declare class DistributionNotDisabled extends __BaseException {
    readonly name: "DistributionNotDisabled";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<DistributionNotDisabled, __BaseException>);
}
/**
 * <p>Cannot delete this resource because it is in use.</p>
 * @public
 */
export declare class ResourceInUse extends __BaseException {
    readonly name: "ResourceInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceInUse, __BaseException>);
}
/**
 * <p>The specified configuration for field-level encryption is in use.</p>
 * @public
 */
export declare class FieldLevelEncryptionConfigInUse extends __BaseException {
    readonly name: "FieldLevelEncryptionConfigInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FieldLevelEncryptionConfigInUse, __BaseException>);
}
/**
 * <p>The specified profile for field-level encryption is in use.</p>
 * @public
 */
export declare class FieldLevelEncryptionProfileInUse extends __BaseException {
    readonly name: "FieldLevelEncryptionProfileInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FieldLevelEncryptionProfileInUse, __BaseException>);
}
/**
 * <p>Cannot delete the function because it's attached to one or more cache behaviors.</p>
 * @public
 */
export declare class FunctionInUse extends __BaseException {
    readonly name: "FunctionInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FunctionInUse, __BaseException>);
}
/**
 * <p>The function does not exist.</p>
 * @public
 */
export declare class NoSuchFunctionExists extends __BaseException {
    readonly name: "NoSuchFunctionExists";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchFunctionExists, __BaseException>);
}
/**
 * <p>A resource that was specified is not valid.</p>
 * @public
 */
export declare class NoSuchResource extends __BaseException {
    readonly name: "NoSuchResource";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchResource, __BaseException>);
}
/**
 * <p>A monitoring subscription does not exist for the specified distribution.</p>
 * @public
 */
export declare class NoSuchMonitoringSubscription extends __BaseException {
    readonly name: "NoSuchMonitoringSubscription";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchMonitoringSubscription, __BaseException>);
}
/**
 * <p>The origin access control does not exist.</p>
 * @public
 */
export declare class NoSuchOriginAccessControl extends __BaseException {
    readonly name: "NoSuchOriginAccessControl";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchOriginAccessControl, __BaseException>);
}
/**
 * <p>Cannot delete the origin access control because it's in use by one or more distributions.</p>
 * @public
 */
export declare class OriginAccessControlInUse extends __BaseException {
    readonly name: "OriginAccessControlInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<OriginAccessControlInUse, __BaseException>);
}
/**
 * <p>Cannot delete the origin request policy because it is attached to one or more cache behaviors.</p>
 * @public
 */
export declare class OriginRequestPolicyInUse extends __BaseException {
    readonly name: "OriginRequestPolicyInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<OriginRequestPolicyInUse, __BaseException>);
}
/**
 * <p>The specified public key is in use.</p>
 * @public
 */
export declare class PublicKeyInUse extends __BaseException {
    readonly name: "PublicKeyInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<PublicKeyInUse, __BaseException>);
}
/**
 * <p>Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.</p>
 * @public
 */
export declare class RealtimeLogConfigInUse extends __BaseException {
    readonly name: "RealtimeLogConfigInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<RealtimeLogConfigInUse, __BaseException>);
}
/**
 * <p>Cannot delete the response headers policy because it is attached to one or more cache behaviors in a CloudFront distribution.</p>
 * @public
 */
export declare class ResponseHeadersPolicyInUse extends __BaseException {
    readonly name: "ResponseHeadersPolicyInUse";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResponseHeadersPolicyInUse, __BaseException>);
}
/**
 * <p>The specified streaming distribution does not exist.</p>
 * @public
 */
export declare class NoSuchStreamingDistribution extends __BaseException {
    readonly name: "NoSuchStreamingDistribution";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchStreamingDistribution, __BaseException>);
}
/**
 * <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
 * @public
 */
export declare class StreamingDistributionNotDisabled extends __BaseException {
    readonly name: "StreamingDistributionNotDisabled";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<StreamingDistributionNotDisabled, __BaseException>);
}
/**
 * <p>The specified invalidation does not exist.</p>
 * @public
 */
export declare class NoSuchInvalidation extends __BaseException {
    readonly name: "NoSuchInvalidation";
    readonly $fault: "client";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NoSuchInvalidation, __BaseException>);
}
/**
 * <p>The CloudFront function failed.</p>
 * @public
 */
export declare class TestFunctionFailed extends __BaseException {
    readonly name: "TestFunctionFailed";
    readonly $fault: "server";
    Message?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TestFunctionFailed, __BaseException>);
}
