/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.compress;

import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.compress.Expand;
import net.sourceforge.plantuml.klimt.compress.ExpandType;
import net.sourceforge.plantuml.klimt.compress.PiecewiseAffineTransform;

public class ExpandTransform
implements PiecewiseAffineTransform {
    private final Set<Expand> all = new TreeSet<Expand>();

    public String toString() {
        return this.all.toString();
    }

    public void addExpandIncludingLimit(double position, double extend) {
        this.all.add(new Expand(ExpandType.INCLUDING_LIMIT, position, extend));
    }

    public void addExpandExcludingLimit(double position, double extend) {
        this.all.add(new Expand(ExpandType.EXCLUDING_LIMIT, position, extend));
    }

    @Override
    public double transform(double init) {
        double result = init;
        for (Expand expand : this.all) {
            if (ExpandType.INCLUDING_LIMIT == expand.getType() && init >= expand.getPosition()) {
                result += expand.getExtend();
            }
            if (ExpandType.EXCLUDING_LIMIT != expand.getType() || !(init > expand.getPosition())) continue;
            result += expand.getExtend();
        }
        return result;
    }
}

