/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final Url url;
    private double angle;

    public StyleSignature getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getStyleName(), SName.circle).withTOBECHANGED(this.getStereo());
    }

    private UStroke getUStroke() {
        return UStroke.withThickness(1.5);
    }

    public EntityImageLollipopInterface(Entity entity) {
        super(entity);
        FontConfiguration fc = FontConfiguration.create(this.getSkinParam(), this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder()));
        this.desc = entity.getDisplay().create(fc, HorizontalAlignment.CENTER, this.getSkinParam());
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(10.0, 10.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle;
        Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        double shadow = style.getShadowing();
        if (this.getEntity().getLeafType() == LeafType.LOLLIPOP_HALF) {
            circle = new UEllipse(10.0, 10.0, this.angle - 90.0, 180.0);
        } else {
            circle = UEllipse.build(10.0, 10.0);
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                circle.setDeltaShadow(shadow);
            }
        }
        ug = ug.apply(backgroundColor.bg()).apply(borderColor);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UGroup group = new UGroup(this.getEntity().getLocation());
        group.put(UGroupType.CLASS, "entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        ug.apply(this.getUStroke()).draw(circle);
        ug.closeGroup();
        XDimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double x = 5.0 - widthDesc / 2.0;
        double y = 10.0;
        this.desc.drawU(ug.apply(new UTranslate(x, 10.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    public void addImpact(double angle) {
        this.angle = 180.0 - angle * 180.0 / Math.PI;
    }
}

