/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IndividualSpacings;

public final class CuttingUtils {
    private CuttingUtils() {
    }

    public static List<LEdge> insertDummies(LGraph layeredGraph, LEdge originalEdge, int offsetFirstInLayerDummy) {
        double edgeNodeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE);
        double additionalSpacing = layeredGraph.getProperty(LayeredOptions.WRAPPING_ADDITIONAL_EDGE_SPACING);
        IndividualSpacings is = new IndividualSpacings();
        is.setProperty(LayeredOptions.SPACING_EDGE_NODE, (Object)(edgeNodeSpacing + additionalSpacing));
        LEdge edge = originalEdge;
        LPort targetPort = edge.getTarget();
        LNode src = edge.getSource().getNode();
        LNode tgt = edge.getTarget().getNode();
        int srcIndex = src.getLayer().getIndex();
        int tgtIndex = tgt.getLayer().getIndex();
        ArrayList<LEdge> createdEdges = Lists.newArrayList();
        int i = srcIndex;
        while (i <= tgtIndex) {
            LNode dummyNode = new LNode(layeredGraph);
            dummyNode.setType(LNode.NodeType.LONG_EDGE);
            dummyNode.setProperty(InternalProperties.ORIGIN, edge);
            dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
            dummyNode.setProperty(LayeredOptions.SPACING_INDIVIDUAL, is);
            Layer nextLayer = layeredGraph.getLayers().get(i);
            if (i == srcIndex) {
                dummyNode.setLayer(nextLayer.getNodes().size() - offsetFirstInLayerDummy, nextLayer);
            } else {
                dummyNode.setLayer(nextLayer);
            }
            double thickness = edge.getProperty(LayeredOptions.EDGE_THICKNESS);
            if (thickness < 0.0) {
                thickness = 0.0;
                edge.setProperty(LayeredOptions.EDGE_THICKNESS, (Object)thickness);
            }
            dummyNode.getSize().y = thickness;
            double portPos = Math.floor(thickness / 2.0);
            LPort dummyInput = new LPort();
            dummyInput.setSide(PortSide.WEST);
            dummyInput.setNode(dummyNode);
            dummyInput.getPosition().y = portPos;
            LPort dummyOutput = new LPort();
            dummyOutput.setSide(PortSide.EAST);
            dummyOutput.setNode(dummyNode);
            dummyOutput.getPosition().y = portPos;
            edge.setTarget(dummyInput);
            LEdge dummyEdge = new LEdge();
            dummyEdge.copyProperties(edge);
            dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
            dummyEdge.setSource(dummyOutput);
            dummyEdge.setTarget(targetPort);
            CuttingUtils.setDummyProperties(dummyNode, edge, dummyEdge);
            createdEdges.add(dummyEdge);
            edge = dummyEdge;
            ++i;
        }
        return createdEdges;
    }

    private static void setDummyProperties(LNode dummy, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        if (inEdgeSourceNode.getType() == LNode.NodeType.LONG_EDGE) {
            dummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummy.setProperty(InternalProperties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
        } else {
            dummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdge.getSource());
            dummy.setProperty(InternalProperties.LONG_EDGE_TARGET, outEdge.getTarget());
        }
    }
}

