/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p4route;

import java.util.LinkedList;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.Triple;

public class MultiLevelEdgeNodeNodeGap {
    private TNode neighborOne;
    private TNode neighborTwo;
    private LinkedList<Triple<KVector, KVector, TEdge>> bendPoints;
    private TGraph graph;
    private Direction d;
    private double nodeBendpointPadding;
    private boolean onFirstNodeSide;
    private boolean onLastNodeSide;

    public TNode getNeighborOne() {
        return this.neighborOne;
    }

    public TNode getNeighborTwo() {
        return this.neighborTwo;
    }

    public boolean isOnFirstNodeSide() {
        return this.onFirstNodeSide;
    }

    public boolean isOnLastNodeSide() {
        return this.onLastNodeSide;
    }

    public MultiLevelEdgeNodeNodeGap(TNode neighborOne, TNode neighborTwo, Triple<KVector, KVector, TEdge> bendTriple, TGraph graph) {
        this.neighborOne = neighborOne;
        this.neighborTwo = neighborTwo;
        this.graph = graph;
        LinkedList<Triple<KVector, KVector, TEdge>> bends = new LinkedList<Triple<KVector, KVector, TEdge>>();
        bends.add(bendTriple);
        this.bendPoints = bends;
        this.d = graph.getProperty(MrTreeOptions.DIRECTION);
        this.nodeBendpointPadding = graph.getProperty(MrTreeOptions.SPACING_EDGE_NODE);
        this.updateBendPoints();
    }

    public void addBendPoints(Triple<KVector, KVector, TEdge> newBends) {
        this.bendPoints.add(newBends);
        if (this.d.isHorizontal()) {
            this.bendPoints.sort((x, y) -> Double.compare(((TEdge)x.getThird()).getTarget().getPosition().y, ((TEdge)y.getThird()).getTarget().getPosition().y));
        } else {
            this.bendPoints.sort((x, y) -> Double.compare(((TEdge)x.getThird()).getTarget().getPosition().x, ((TEdge)y.getThird()).getTarget().getPosition().x));
        }
        this.updateBendPoints();
    }

    private void updateBendPoints() {
        int i = 0;
        int count = this.bendPoints.size();
        for (Triple triple : this.bendPoints) {
            KVector bend2;
            KVector bend1;
            double interpolation = (double)(i + 1) / (double)(count + 1);
            if (this.neighborOne == null && this.neighborTwo == null) {
                return;
            }
            if (this.neighborOne != null && this.neighborTwo == null) {
                this.onLastNodeSide = true;
                if (this.d == Direction.LEFT) {
                    bendTmp = this.neighborOne.getPosition().y + this.neighborOne.getSize().y + this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.RIGHT) {
                    bendTmp = this.neighborOne.getPosition().y + this.neighborOne.getSize().y + this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.UP) {
                    bendTmp = this.neighborOne.getPosition().x + this.neighborOne.getSize().x + this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                } else {
                    bendTmp = this.neighborOne.getPosition().x + this.neighborOne.getSize().x + this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                }
            } else if (this.neighborOne != null && this.neighborTwo != null) {
                if (this.d == Direction.LEFT) {
                    bendTmp = this.neighborTwo.getPosition().y * interpolation + (this.neighborOne.getPosition().y + this.neighborOne.getSize().y) * (1.0 - interpolation);
                    bend1 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.RIGHT) {
                    bendTmp = this.neighborTwo.getPosition().y * interpolation + (this.neighborOne.getPosition().y + this.neighborOne.getSize().y) * (1.0 - interpolation);
                    bend1 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.UP) {
                    bendTmp = this.neighborTwo.getPosition().x * interpolation + (this.neighborOne.getPosition().x + this.neighborOne.getSize().x) * (1.0 - interpolation);
                    bend1 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                } else {
                    bendTmp = this.neighborTwo.getPosition().x * interpolation + (this.neighborOne.getPosition().x + this.neighborOne.getSize().x) * (1.0 - interpolation);
                    bend1 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborOne.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                }
            } else {
                this.onFirstNodeSide = true;
                if (this.d == Direction.LEFT) {
                    bendTmp = this.neighborTwo.getPosition().y - this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(this.neighborTwo.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborTwo.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.RIGHT) {
                    bendTmp = this.neighborTwo.getPosition().y - this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(this.neighborTwo.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding, bendTmp);
                    bend2 = new KVector(this.neighborTwo.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding, bendTmp);
                } else if (this.d == Direction.UP) {
                    bendTmp = this.neighborTwo.getPosition().x - this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(bendTmp, this.neighborTwo.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborTwo.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                } else {
                    bendTmp = this.neighborTwo.getPosition().x - this.nodeBendpointPadding * (double)(i + 1);
                    bend1 = new KVector(bendTmp, this.neighborTwo.getProperty(InternalProperties.LEVELMIN) - this.nodeBendpointPadding);
                    bend2 = new KVector(bendTmp, this.neighborTwo.getProperty(InternalProperties.LEVELMAX) + this.nodeBendpointPadding);
                }
            }
            ((KVector)triple.getFirst()).x = bend1.x;
            ((KVector)triple.getFirst()).y = bend1.y;
            ((KVector)triple.getSecond()).x = bend2.x;
            ((KVector)triple.getSecond()).y = bend2.y;
            ++i;
        }
    }
}

