/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.keystroke;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;
import org.assertj.swing.dependency.fest_reflect.exception.ReflectionError;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.ParsingException;
import org.assertj.swing.keystroke.KeyStrokeMapping;
import org.assertj.swing.keystroke.KeyStrokeMappingProvider;
import org.assertj.swing.keystroke.ParsedKeyStrokeMappingProvider;
import org.assertj.swing.util.Maps;

public class KeyStrokeMappingsParser {
    private static final Map<String, Character> SPECIAL_MAPPINGS = Maps.newHashMap();

    @Nonnull
    public KeyStrokeMappingProvider parse(@Nonnull String fileName) {
        Preconditions.checkNotNullOrEmpty((CharSequence)fileName);
        try {
            return this.parse(this.fileAsStream(fileName));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"An I/O error ocurred while parsing file ", fileName}), e);
        }
    }

    @Nonnull
    private InputStream fileAsStream(String file) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (stream == null) {
            throw new ParsingException(String.format("Unable to open file %s", file));
        }
        return stream;
    }

    @Nonnull
    public KeyStrokeMappingProvider parse(@Nonnull File file) {
        Assertions.assertThat((File)file).isFile();
        try {
            return this.parse(this.fileAsStream(file));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"An I/O error ocurred while parsing file ", file}), e);
        }
    }

    @Nonnull
    private InputStream fileAsStream(@Nonnull File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            String msg = String.format("The file %s was not found", file.getPath());
            throw new ParsingException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private KeyStrokeMappingProvider parse(@Nonnull InputStream input) throws IOException {
        ParsedKeyStrokeMappingProvider parsedKeyStrokeMappingProvider;
        ArrayList mappings = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String line = reader.readLine();
            while (line != null) {
                mappings.add(this.mappingFrom(line));
                line = reader.readLine();
            }
            parsedKeyStrokeMappingProvider = new ParsedKeyStrokeMappingProvider(mappings);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        Closeables.closeQuietly((Closeable[])new Closeable[]{reader});
        return parsedKeyStrokeMappingProvider;
    }

    @Nonnull
    @VisibleForTesting
    KeyStrokeMapping mappingFrom(@Nonnull String line) {
        String[] parts = line.trim().split(",");
        if (parts.length != 3) {
            String msg = String.format("Line '%s' does not conform with pattern '{char}, {keycode}, {modifiers}'", line);
            throw new ParsingException(msg);
        }
        char character = KeyStrokeMappingsParser.characterFrom(parts[0].trim());
        int keyCode = KeyStrokeMappingsParser.keyCodeFrom(parts[1].trim());
        int modifiers = KeyStrokeMappingsParser.modifiersFrom(parts[2].trim());
        return KeyStrokeMapping.mapping(character, keyCode, modifiers);
    }

    private static char characterFrom(@Nonnull String s) {
        if (SPECIAL_MAPPINGS.containsKey(s)) {
            return SPECIAL_MAPPINGS.get(s).charValue();
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        throw new ParsingException(String.format("The text '%s' should have a single character", s));
    }

    private static int keyCodeFrom(@Nonnull String s) {
        try {
            Integer keyCode = Reflection.field("VK_" + s).ofType(Integer.TYPE).in(KeyEvent.class).get();
            return (Integer)Preconditions.checkNotNull((Object)keyCode);
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"Unable to retrieve key code from text ", Strings.quote((String)s)}), e.getCause());
        }
    }

    private static int modifiersFrom(@Nonnull String s) {
        if ("NO_MASK".equals(s)) {
            return 0;
        }
        try {
            Integer modifiers = Reflection.field(s).ofType(Integer.TYPE).in(InputEvent.class).get();
            return (Integer)Preconditions.checkNotNull((Object)modifiers);
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"Unable to retrieve modifiers from text ", Strings.quote((String)s)}), e.getCause());
        }
    }

    static {
        SPECIAL_MAPPINGS.put("COMMA", Character.valueOf(','));
    }
}

