/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.ConfigStatus;
import git4idea.FsMonitor;
import git4idea.config.GitConfigUtil;
import git4idea.index.GitFileStatus;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.repo.GitRepository;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"isWorkTreeUsed", "", "Lgit4idea/repo/GitRepository;", "getConfigFileStatus", "Lgit4idea/ConfigStatus;", "repository", "configDirName", "", "detectFsMonitor", "Lgit4idea/FsMonitor;", "intellij.vcs.git"})
public final class GitStatisticsCollectorKt {
    private static final boolean isWorkTreeUsed(GitRepository $this$isWorkTreeUsed) {
        boolean bl;
        try {
            Path path = $this$isWorkTreeUsed.getRoot().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path rootPath = path;
            String[] stringArray = new String[]{".git"};
            Path dotGit = Path.of(((Object)rootPath).toString(), stringArray);
            Intrinsics.checkNotNull((Object)dotGit);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(dotGit, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return true;
            }
            Path worktreesPath = $this$isWorkTreeUsed.getRepositoryFiles().getWorktreesDirFile().toPath();
            Intrinsics.checkNotNull((Object)worktreesPath);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists(worktreesPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return false;
            }
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.isDirectory(worktreesPath, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                return false;
            }
            bl = Files.list(worktreesPath).count() > 0L;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    private static final ConfigStatus getConfigFileStatus(GitRepository repository2, String configDirName) {
        try {
            Path configDir;
            block9: {
                block8: {
                    Path path = repository2.getRoot().toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    Path rootPath = path;
                    configDir = rootPath.resolve(configDirName);
                    Intrinsics.checkNotNull((Object)configDir);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(configDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block8;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (Files.isDirectory(configDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block9;
                }
                return null;
            }
            FilePath filePath = VcsUtil.getFilePath((Path)configDir, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            FilePath filePath2 = filePath;
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = repository2.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            List<GitFileStatus> status = GitIndexStatusUtilKt.getStatus(project, virtualFile, CollectionsKt.listOf((Object)filePath2), false, true, true);
            GitFileStatus gitFileStatus = (GitFileStatus)CollectionsKt.singleOrNull(status);
            if (gitFileStatus == null) {
                return ConfigStatus.SHARED;
            }
            GitFileStatus fileStatus = gitFileStatus;
            if (fileStatus.isIgnored() && Intrinsics.areEqual((Object)fileStatus.getPath().getPath(), (Object)filePath2.getPath())) {
                return ConfigStatus.IGNORED;
            }
            return ConfigStatus.SHARED;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            return null;
        }
    }

    private static final FsMonitor detectFsMonitor(GitRepository $this$detectFsMonitor) {
        try {
            boolean useBuiltIn = Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.useBuiltinFSMonitor")), (Object)true);
            if (useBuiltIn) {
                return FsMonitor.BUILTIN;
            }
            String fsMonitorHook = GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.fsmonitor");
            if (fsMonitorHook != null && !Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(fsMonitorHook), (Object)false)) {
                return FsMonitor.EXTERNAL_FS_MONITOR;
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return FsMonitor.NONE;
    }

    public static final /* synthetic */ boolean access$isWorkTreeUsed(GitRepository $receiver) {
        return GitStatisticsCollectorKt.isWorkTreeUsed($receiver);
    }

    public static final /* synthetic */ FsMonitor access$detectFsMonitor(GitRepository $receiver) {
        return GitStatisticsCollectorKt.detectFsMonitor($receiver);
    }

    public static final /* synthetic */ ConfigStatus access$getConfigFileStatus(GitRepository repository2, String configDirName) {
        return GitStatisticsCollectorKt.getConfigFileStatus(repository2, configDirName);
    }
}

