/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<GitFileRevision> {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);

    public GitDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(0);
        }
        super(project);
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        GitFileRevision rev;
        Collection<String> parents;
        if (e == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(3);
        }
        if (previousRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(4);
        }
        if (revision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(5);
        }
        if ((parents = (rev = (GitFileRevision)revision).getParents()).size() < 2) {
            super.showDiffForOne(e, project, filePath, previousRevision, revision);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull GitFileRevision rev1, @Nullable GitFileRevision rev2) throws VcsException {
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(6);
        }
        if (rev1 == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(7);
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, path);
        String hash1 = rev1.getHash();
        if (rev2 == null) {
            return new ArrayList<Change>(GitChangeUtils.getDiffWithWorkingDir(this.myProject, root, hash1, Collections.singleton(path), false));
        }
        String hash2 = rev2.getHash();
        return new ArrayList<Change>(GitChangeUtils.getDiff(this.myProject, root, hash1, hash2, Collections.singletonList(path)));
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull GitFileRevision rev) throws VcsException {
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(8);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(9);
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, path);
        return new ArrayList<Change>(GitChangeUtils.getRevisionChanges(this.myProject, root, rev.getHash(), false, true, true).getChanges());
    }

    @NotNull
    protected String getPresentableName(@NotNull GitFileRevision revision) {
        if (revision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(10);
        }
        String string = DvcsUtil.getShortHash((String)revision.getHash());
        if (string == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    private void showDiffForMergeCommit(@NotNull AnActionEvent event, @NotNull FilePath filePath, @NotNull GitFileRevision rev, @NotNull Collection<String> parents) {
        VcsHistorySession session;
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(12);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(13);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(14);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(15);
        }
        List revisions = (session = (VcsHistorySession)event.getData(VcsDataKeys.HISTORY_SESSION)) != null ? session.getRevisionList() : null;
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, revisions, (Consumer<? super MergeCommitPreCheckInfo>)((Consumer)info -> {
            if (!info.wasFileTouched()) {
                String message = GitBundle.message("git.history.diff.handler.no.changes.in.file.info", filePath.getName());
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)message, (MessageType)MessageType.INFO);
            }
            this.showPopup(event, rev, filePath, info.getParents());
        }));
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, final @NotNull Collection<String> parentHashes, final @Nullable List<? extends VcsFileRevision> revisions, final @NotNull Consumer<? super MergeCommitPreCheckInfo> resultHandler) {
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(16);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(17);
        }
        if (parentHashes == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(18);
        }
        if (resultHandler == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(19);
        }
        final Project project = this.myProject;
        new Task.Backgroundable(project, GitBundle.message("git.history.diff.handler.load.changes.process", new Object[0]), true){
            private MergeCommitPreCheckInfo myInfo;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    VirtualFile root = GitUtil.getRootForFile(project, filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.wasFileTouched(project, root, rev);
                    Collection<GitFileRevision> parents = GitDiffFromHistoryHandler.this.findParentRevisions(root, rev, parentHashes, revisions);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    GitDiffFromHistoryHandler.this.showError(e, GitBundle.message("git.history.diff.handler.git.show.error", rev, filePath));
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/GitDiffFromHistoryHandler$1", "run"));
            }
        }.queue();
    }

    @NotNull
    private Collection<GitFileRevision> findParentRevisions(@NotNull VirtualFile root, @NotNull GitFileRevision currentRevision, @NotNull Collection<String> parentHashes, @Nullable List<? extends VcsFileRevision> revisions) throws VcsException {
        if (root == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(20);
        }
        if (currentRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(21);
        }
        if (parentHashes == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(22);
        }
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(root, currentRevision, parentHash, revisions));
        }
        ArrayList<GitFileRevision> arrayList = parents;
        if (arrayList == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private GitFileRevision createParentRevision(@NotNull VirtualFile root, @NotNull GitFileRevision currentRevision, @NotNull String parentHash, @Nullable List<? extends VcsFileRevision> revisions) throws VcsException {
        FilePath currentRevisionPath;
        if (root == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(24);
        }
        if (currentRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(25);
        }
        if (parentHash == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(26);
        }
        if (revisions != null) {
            for (VcsFileRevision vcsFileRevision : revisions) {
                if (!((GitFileRevision)vcsFileRevision).getHash().equals(parentHash)) continue;
                GitFileRevision gitFileRevision = (GitFileRevision)vcsFileRevision;
                if (gitFileRevision == null) {
                    GitDiffFromHistoryHandler.$$$reportNull$$$0(27);
                }
                return gitFileRevision;
            }
        }
        if ((currentRevisionPath = currentRevision.getPath()).isDirectory()) {
            return this.makeRevisionFromHash(currentRevisionPath, parentHash);
        }
        Collection<Change> collection = GitChangeUtils.getDiff(this.myProject, root, parentHash, currentRevision.getHash(), null);
        for (Change change : collection) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            return this.makeRevisionFromHash(path, parentHash);
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        return this.makeRevisionFromHash(currentRevisionPath, parentHash);
    }

    private void showPopup(@NotNull AnActionEvent event, @NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<? extends GitFileRevision> parents) {
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(28);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(29);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(30);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(31);
        }
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(GitBundle.message("git.history.diff.handler.choose.parent.popup", new Object[0]), parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(@NotNull ListPopup popup, @NotNull AnActionEvent event, @NotNull DataContext dataContext) {
        if (popup == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(32);
        }
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(34);
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private ActionGroup createActionGroup(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<? extends GitFileRevision> parents) {
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(35);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(36);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(37);
        }
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(2);
        for (GitFileRevision gitFileRevision : parents) {
            actions2.add(this.createParentAction(rev, filePath, gitFileRevision));
        }
        return new DefaultActionGroup(actions2.toArray(AnAction.EMPTY_ARRAY));
    }

    @NotNull
    private AnAction createParentAction(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull GitFileRevision parent) {
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(38);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(39);
        }
        if (parent == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(40);
        }
        return new ShowDiffWithParentAction(filePath, rev, parent);
    }

    @NotNull
    private GitFileRevision makeRevisionFromHash(@NotNull FilePath filePath, @NotNull String hash) {
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(41);
        }
        if (hash == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(42);
        }
        return new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
    }

    private static boolean wasFileTouched(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileRevision rev) throws VcsException {
        if (project == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(43);
        }
        if (root == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(44);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(45);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.SHOW);
        handler.addParameters(rev.getHash());
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        result2.throwOnError(new int[0]);
        return GitDiffFromHistoryHandler.isFilePresentInOutput(root, rev.getPath(), result2.getOutput());
    }

    private static boolean isFilePresentInOutput(@NotNull VirtualFile root, @NotNull FilePath path, @NotNull List<String> output2) {
        String relativePath;
        if (root == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(46);
        }
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(47);
        }
        if (output2 == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(48);
        }
        if ((relativePath = GitDiffFromHistoryHandler.getRelativePath(root, path)) == null) {
            return false;
        }
        for (String line : output2) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile root, @NotNull FilePath path) {
        if (root == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(49);
        }
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(50);
        }
        return FileUtil.getRelativePath((String)root.getPath(), (String)path.getPath(), (char)'/');
    }

    @NotNull
    @NlsSafe
    private static String getRevisionDescription(@NotNull GitFileRevision parent) {
        if (parent == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(51);
        }
        String hash = DvcsUtil.getShortHash((String)parent.getHash());
        Object message = parent.getCommitMessage();
        if (message != null) {
            int index = StringUtil.indexOfAny((String)message, (String)"\n\r");
            if (index != -1) {
                message = ((String)message).substring(0, index) + "...";
            }
            if (((String)message).length() > 40) {
                message = ((String)message).substring(0, 35) + "...";
            }
            String string = hash + " - " + (String)message;
            if (string == null) {
                GitDiffFromHistoryHandler.$$$reportNull$$$0(52);
            }
            return string;
        }
        String string = hash;
        if (string == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 23, 27, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 30: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRevision";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 6: 
            case 8: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev1";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 29: 
            case 35: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 11: 
            case 23: 
            case 27: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitDiffFromHistoryHandler";
                break;
            }
            case 12: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHashes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultHandler";
                break;
            }
            case 20: 
            case 24: 
            case 44: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevision";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHash";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitDiffFromHistoryHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentRevisions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentRevision";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForOne";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChangesBetweenRevisions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 11: 
            case 23: 
            case 27: 
            case 52: 
            case 53: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForMergeCommit";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkIfFileWasTouchedAndFindParentsInBackground";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findParentRevisions";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createParentRevision";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInBestPosition";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroup";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createParentAction";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "makeRevisionFromHash";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "wasFileTouched";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isFilePresentInOutput";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 23, 27, 52, 53 -> new IllegalStateException(string);
        };
    }

    private class ShowDiffWithParentAction
    extends DumbAwareAction {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final GitFileRevision myRevision;
        @NotNull
        private final GitFileRevision myParentRevision;

        ShowDiffWithParentAction(@NotNull FilePath filePath, @NotNull GitFileRevision rev, GitFileRevision parent) {
            if (filePath == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(0);
            }
            if (rev == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(2);
            }
            super(GitDiffFromHistoryHandler.getRevisionDescription(parent), parent.getCommitMessage(), null);
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(3);
            }
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rev";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

