/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GitRebaseUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUpdater.class.getName());
    @NotNull
    private final GitBranchPair myBranchPair;

    public GitRebaseUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository2, @NotNull GitBranchPair branchPair, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            GitRebaseUpdater.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRebaseUpdater.$$$reportNull$$$0(1);
        }
        if (repository2 == null) {
            GitRebaseUpdater.$$$reportNull$$$0(2);
        }
        if (branchPair == null) {
            GitRebaseUpdater.$$$reportNull$$$0(3);
        }
        if (progressIndicator == null) {
            GitRebaseUpdater.$$$reportNull$$$0(4);
        }
        if (updatedFiles == null) {
            GitRebaseUpdater.$$$reportNull$$$0(5);
        }
        super(project, git, repository2, progressIndicator, updatedFiles);
        this.myBranchPair = branchPair;
    }

    @Override
    public boolean isSaveNeeded() {
        Collection localChanges = (Collection)LocalChangesUnderRoots.getChangesUnderRoots(Collections.singletonList(this.myRoot), (Project)this.myProject).get(this.myRoot);
        try {
            return !ContainerUtil.isEmpty((Collection)localChanges) || GitUtil.hasLocalChanges(true, this.myProject, this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("isSaveNeeded failed to check local changes", (Throwable)e);
            return true;
        }
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        LOG.info("doUpdate ");
        if (!this.checkForRebasingPublishedCommits()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.CANCEL;
            if (gitUpdateResult == null) {
                GitRebaseUpdater.$$$reportNull$$$0(6);
            }
            return gitUpdateResult;
        }
        String remoteBranch = this.getRemoteBranchToMerge();
        List<String> params = Collections.singletonList(remoteBranch);
        GitUpdateResult result2 = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator).rebase(this.myRoot, params, null);
        if (result2 == GitUpdateResult.CANCEL) {
            new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator).abortRebase(this.myRoot);
        }
        GitUpdateResult gitUpdateResult = result2;
        if (gitUpdateResult == null) {
            GitRebaseUpdater.$$$reportNull$$$0(7);
        }
        return gitUpdateResult;
    }

    private boolean checkForRebasingPublishedCommits() {
        GitBranchPair sourceAndTarget = this.getSourceAndTarget();
        String currentRef = sourceAndTarget.getSource().getFullName();
        String baseRef = sourceAndTarget.getTarget().getFullName();
        GitRebaseParams.RebaseUpstream.Reference upstream = GitRebaseParams.RebaseUpstream.Companion.fromRefString(baseRef);
        if (GitRebaseProcess.isRebasingPublishedCommit(this.myRepository, upstream, currentRef)) {
            return GitRebaseProcess.askIfShouldRebasePublishedCommit();
        }
        return true;
    }

    @NotNull
    private String getRemoteBranchToMerge() {
        String string = this.myBranchPair.getTarget().getName();
        if (string == null) {
            GitRebaseUpdater.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    GitBranchPair getSourceAndTarget() {
        GitBranchPair gitBranchPair = this.myBranchPair;
        if (gitBranchPair == null) {
            GitRebaseUpdater.$$$reportNull$$$0(9);
        }
        return gitBranchPair;
    }

    public String toString() {
        return "Rebase updater";
    }

    public boolean fastForwardMerge() {
        LOG.info("Trying fast-forward merge for " + String.valueOf(this.myRoot));
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot(this.myRoot);
        if (repository2 == null) {
            LOG.error("Repository is null for " + String.valueOf(this.myRoot));
            return false;
        }
        try {
            this.markStart(repository2);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark start for repository " + String.valueOf(repository2), (Throwable)e);
            return false;
        }
        GitCommandResult result2 = this.myGit.merge(repository2, this.getRemoteBranchToMerge(), Collections.singletonList("--ff-only"), new GitLineHandlerListener[0]);
        try {
            this.markEnd(repository2);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark end for repository " + String.valueOf(repository2), (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("git.rebase.collect.updated.changes.error", GitBundle.message("notification.title.couldnt.collect.updated.files.info", new Object[0]), GitBundle.message("notification.content.couldnt.collect.updated.files.info", repository2));
        }
        return result2.success();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitRebaseUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitRebaseUpdater";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranchToMerge";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceAndTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

