/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.editor;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.frontend.editor.XDebuggerLineChangeHandler;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.settings.ShowBreakpointsOverLineNumbersAction;
import java.awt.Cursor;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BreakpointPromoterEditorListener
implements EditorMouseMotionListener {
    private XSourcePositionImpl myLastPosition = null;
    private Icon myLastIcon = null;
    private final Project myProject;
    private final XDebuggerLineChangeHandler lineChangeHandler;

    public BreakpointPromoterEditorListener(Project project, CoroutineScope coroutineScope) {
        this.myProject = project;
        this.lineChangeHandler = new XDebuggerLineChangeHandler(coroutineScope, (Function3<? super EditorGutterComponentEx, ? super XSourcePositionImpl, ? super Icon, Unit>)((Function3)(gutter, position, icon) -> {
            this.myLastIcon = icon;
            if (this.myLastIcon != null) {
                BreakpointPromoterEditorListener.updateActiveLineNumberIcon(gutter, this.myLastIcon, position.getLine());
            }
            return Unit.INSTANCE;
        }));
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            BreakpointPromoterEditorListener.$$$reportNull$$$0(0);
        }
        if (!ExperimentalUI.isNewUI() || !ShowBreakpointsOverLineNumbersAction.isSelected()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != this.myProject || editor.getEditorKind() != EditorKind.MAIN_EDITOR) {
            return;
        }
        EditorGutter editorGutter = editor.getGutter();
        if (editorGutter instanceof EditorGutterComponentEx) {
            XSourcePositionImpl position;
            Document document;
            int line;
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)editorGutter;
            if (e.getArea() == EditorMouseEventArea.LINE_NUMBERS_AREA && EditorUtil.isBreakPointsOnLineNumbers() && DocumentUtil.isValidLine((int)(line = EditorUtil.yToLogicalLineNoCustomRenderers((Editor)editor, (int)e.getMouseEvent().getY())), (Document)(document = editor.getDocument())) && (position = XSourcePositionImpl.create((VirtualFile)FileDocumentManager.getInstance().getFile(document), (int)line)) != null) {
                if (this.myLastPosition == null || !this.myLastPosition.getFile().equals(position.getFile()) || this.myLastPosition.getLine() != line) {
                    this.clear(gutter);
                    this.myLastPosition = position;
                    this.lineChangeHandler.lineChanged(editor, position);
                }
                return;
            }
            if (this.myLastIcon != null) {
                this.clear(gutter);
                this.myLastPosition = null;
                this.lineChangeHandler.exitedGutter();
            }
        }
    }

    private void clear(EditorGutterComponentEx gutter) {
        BreakpointPromoterEditorListener.updateActiveLineNumberIcon(gutter, null, null);
        this.myLastIcon = null;
    }

    private static void updateActiveLineNumberIcon(@NotNull EditorGutterComponentEx gutter, @Nullable Icon icon, @Nullable Integer line) {
        if (gutter == null) {
            BreakpointPromoterEditorListener.$$$reportNull$$$0(1);
        }
        if (gutter.getClientProperty((Object)"editor.gutter.context.menu") != null) {
            return;
        }
        boolean requireRepaint = false;
        if (gutter.getClientProperty((Object)"line.number.hover.icon") != icon) {
            gutter.putClientProperty((Object)"line.number.hover.icon", (Object)icon);
            gutter.putClientProperty((Object)"line.number.hover.icon.context.menu", icon == null ? null : ActionManager.getInstance().getAction("XDebugger.Hover.Breakpoint.Context.Menu"));
            if (icon != null) {
                gutter.setCursor(Cursor.getPredefinedCursor(12));
            }
            requireRepaint = true;
        }
        if (!Objects.equals(gutter.getClientProperty((Object)"active.line.number"), line)) {
            gutter.putClientProperty((Object)"active.line.number", (Object)line);
            requireRepaint = true;
        }
        if (requireRepaint) {
            gutter.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/debugger/impl/frontend/editor/BreakpointPromoterEditorListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateActiveLineNumberIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

