/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.diff.Block;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.history.integration.ui.models.RevisionDataKt;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.RevisionId;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SelectionReverter
extends Reverter {
    private final SelectionCalculator myCalculator;
    @NotNull
    private final RevisionId myTargetRevisionId;
    @NlsSafe
    private final String myTargetPath;
    private final int myFromLine;
    private final int myToLine;

    public SelectionReverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, SelectionCalculator c, Revision targetRevision, Entry rightEntry, int fromLine, int toLine) {
        this(p, vcs, gw, c, RevisionDataKt.toRevisionId(targetRevision), rightEntry.getPath(), fromLine, toLine, () -> Reverter.getRevertCommandName(targetRevision));
    }

    public SelectionReverter(Project project, LocalHistoryFacade facade, IdeaGateway gateway, SelectionCalculator calculator, @NotNull RevisionId targetRevisionId, String targetPath, int fromLine, int toLine, @NotNull Supplier<@NlsContexts.Command String> commandName) {
        if (targetRevisionId == null) {
            SelectionReverter.$$$reportNull$$$0(0);
        }
        if (commandName == null) {
            SelectionReverter.$$$reportNull$$$0(1);
        }
        super(project, facade, gateway, commandName);
        this.myCalculator = calculator;
        this.myTargetRevisionId = targetRevisionId;
        this.myTargetPath = targetPath;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getFilesToClearROStatus() {
        List<VirtualFile> list = Collections.singletonList(this.myGateway.findVirtualFile(this.myTargetPath));
        if (list == null) {
            SelectionReverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected void doRevert() {
        Block b = this.myCalculator.getSelectionFor(this.myTargetRevisionId, Progress.EMPTY);
        Document d = this.myGateway.getDocument(this.myTargetPath);
        int from = d.getLineStartOffset(this.myFromLine);
        int to = d.getLineEndOffset(this.myToLine);
        d.replaceString(from, to, (CharSequence)b.getBlockContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRevisionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/revertion/SelectionReverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/revertion/SelectionReverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToClearROStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

