/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.BuiltInDictionariesProvider;
import com.intellij.spellchecker.settings.BuiltInDictionary;
import com.intellij.spellchecker.settings.CustomDictionarySettingsListener;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomDictionariesPanel
extends JPanel {
    private final SpellCheckerSettings mySettings;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpellCheckerManager myManager;
    private final CustomDictionariesTableView myCustomDictionariesTableView;
    private final List<String> removedDictionaries;
    private final List<String> defaultDictionaries;
    private final Map<String, BuiltInDictionary> builtInDictionaries;

    public CustomDictionariesPanel(@NotNull SpellCheckerSettings settings, final @NotNull Project project, final @NotNull SpellCheckerManager manager) {
        if (settings == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(2);
        }
        this.removedDictionaries = new ArrayList<String>();
        this.mySettings = settings;
        this.myProject = project;
        this.myManager = manager;
        this.defaultDictionaries = project.isDefault() ? new ArrayList<String>() : Arrays.asList(SpellCheckerBundle.message("app.dictionary", new Object[0]), SpellCheckerBundle.message("project.dictionary", new Object[0]));
        this.builtInDictionaries = new HashMap<String, BuiltInDictionary>();
        BuiltInDictionariesProvider.getAll().stream().map(BuiltInDictionariesProvider::getDictionaries).flatMap(Collection::stream).forEach(dictionary -> this.builtInDictionaries.put(dictionary.getName(), (BuiltInDictionary)dictionary));
        this.myCustomDictionariesTableView = new CustomDictionariesTableView(new ArrayList<String>(settings.getCustomDictionariesPaths()), this.defaultDictionaries, this.builtInDictionaries.keySet().stream().toList());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myCustomDictionariesTableView)).setAddActionName(SpellCheckerBundle.message("add.custom.dictionaries", new Object[0])).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CustomDictionariesPanel.this.myCustomDictionariesTableView.stopEditing();
                CustomDictionariesPanel.this.doChooseFiles(project, (Consumer<? super List<VirtualFile>>)((Consumer)files -> files.stream().map(VirtualFile::getPath).map(PathUtil::toSystemDependentName).filter(path -> !CustomDictionariesPanel.this.myCustomDictionariesTableView.getItems().contains(path)).forEach(path -> CustomDictionariesPanel.this.myCustomDictionariesTableView.getListTableModel().addRow(path))));
            }
        }).setRemoveActionName(SpellCheckerBundle.message("remove.custom.dictionaries", new Object[0])).setRemoveAction(button -> {
            this.removedDictionaries.addAll(this.myCustomDictionariesTableView.getSelectedObjects());
            TableUtil.removeSelectedItems((JTable)((Object)this.myCustomDictionariesTableView));
        }).setRemoveActionUpdater(e -> !ContainerUtil.exists((Iterable)this.myCustomDictionariesTableView.getSelectedObjects(), x -> this.defaultDictionaries.contains(x) || this.builtInDictionaries.containsKey(x))).setEditActionName(SpellCheckerBundle.message("edit.custom.dictionary", new Object[0])).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedDictionary = (String)CustomDictionariesPanel.this.myCustomDictionariesTableView.getSelectedObject();
                if (selectedDictionary == null) {
                    return;
                }
                if (CustomDictionariesPanel.this.builtInDictionaries.containsKey(selectedDictionary)) {
                    BuiltInDictionary dictionary = CustomDictionariesPanel.this.builtInDictionaries.get(selectedDictionary);
                    dictionary.openDictionaryInEditor(project);
                    return;
                }
                if (CustomDictionariesPanel.this.defaultDictionaries.contains(selectedDictionary)) {
                    selectedDictionary = selectedDictionary.equals(SpellCheckerBundle.message("app.dictionary", new Object[0])) ? CustomDictionariesPanel.this.myManager.getAppDictionaryPath() : CustomDictionariesPanel.this.myManager.getProjectDictionaryPath();
                }
                manager.openDictionaryInEditor(selectedDictionary);
            }
        }).disableUpDownActions();
        this.myCustomDictionariesTableView.getEmptyText().setText(SpellCheckerBundle.message("no.custom.dictionaries", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)decorator.createPanel(), "Center");
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<? super List<VirtualFile>> consumer) {
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(4);
        }
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && SpellCheckerManagerKt.isDic(file.getName());
            }
        };
        VirtualFile directory = ProjectUtil.guessProjectDir((Project)project);
        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, (Component)this.getParent(), (VirtualFile)directory, consumer);
    }

    public List<String> getRemovedDictionaries() {
        return this.removedDictionaries;
    }

    public boolean isModified() {
        List<String> oldPaths = this.mySettings.getCustomDictionariesPaths();
        List collection = this.myCustomDictionariesTableView.getItems();
        if (collection.isEmpty()) {
            return !oldPaths.isEmpty();
        }
        HashSet<String> newPaths = new HashSet<String>();
        for (String t : collection) {
            if (this.defaultDictionaries.contains(t) || this.builtInDictionaries.containsKey(t)) continue;
            newPaths.add(t);
        }
        return oldPaths.size() != newPaths.size() || !newPaths.containsAll(oldPaths) || !oldPaths.containsAll(newPaths);
    }

    public void reset() {
        this.myCustomDictionariesTableView.getListTableModel().setItems(new ArrayList(ContainerUtil.concat((List[])new List[]{this.defaultDictionaries, this.builtInDictionaries.keySet().stream().toList(), this.mySettings.getCustomDictionariesPaths()})));
        this.removedDictionaries.clear();
    }

    public void apply() {
        List<String> oldPaths = this.mySettings.getCustomDictionariesPaths();
        ArrayList<String> newPaths = new ArrayList<String>(ContainerUtil.filter((Collection)this.myCustomDictionariesTableView.getItems(), dict -> !this.defaultDictionaries.contains(dict) && !this.builtInDictionaries.containsKey(dict)));
        this.mySettings.setCustomDictionariesPaths(newPaths);
        this.myManager.updateBundledDictionaries(ContainerUtil.filter(oldPaths, o -> !newPaths.contains(o)));
        ((CustomDictionarySettingsListener)this.myProject.getMessageBus().syncPublisher(CustomDictionarySettingsListener.CUSTOM_DICTIONARY_SETTINGS_TOPIC)).customDictionaryPathsChanged(newPaths);
    }

    public List<String> getValues() {
        return this.myCustomDictionariesTableView.getItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CustomDictionariesTableView
    extends TableView<String> {
        final TableCellRenderer myTypeRenderer;

        private CustomDictionariesTableView(@NotNull List<String> dictionaries, @NotNull List<String> defaultDictionaries, @NotNull List<String> builtInDictionaries) {
            if (dictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(0);
            }
            if (defaultDictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(1);
            }
            if (builtInDictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(2);
            }
            this.myTypeRenderer = CustomDictionariesTableView.createTypeRenderer(defaultDictionaries, builtInDictionaries);
            ArrayList<String> items = new ArrayList<String>(defaultDictionaries);
            items.addAll(builtInDictionaries);
            items.addAll(dictionaries);
            this.setModelAndUpdateColumns(new ListTableModel(this.createDictionaryColumnInfos(), items, 0));
            this.setAutoResizeMode(3);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            this.setTableHeader(null);
        }

        private static TableCellRenderer createTypeRenderer(final List<String> defaultDictionaries, final @NotNull List<String> builtInDictionaries) {
            if (builtInDictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(3);
            }
            return new TableCellRenderer(){
                final SimpleColoredComponent myLabel = new SimpleColoredComponent();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String type;
                    this.myLabel.clear();
                    this.myLabel.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (defaultDictionaries.contains(value) || builtInDictionaries.contains(value)) {
                        type = SpellCheckerBundle.message("built.in.dictionary", new Object[0]);
                    } else {
                        CustomDictionaryProvider provider = null;
                        for (CustomDictionaryProvider dictionaryProvider : CustomDictionaryProvider.EP_NAME.getExtensionList()) {
                            if (!dictionaryProvider.isApplicable((String)value)) continue;
                            provider = dictionaryProvider;
                            break;
                        }
                        type = provider == null ? SpellCheckerBundle.message("words.list.dictionary", new Object[0]) : provider.getDictionaryType();
                    }
                    this.myLabel.append(" [" + type + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    return this.myLabel;
                }
            };
        }

        private ColumnInfo[] createDictionaryColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<String, String>(SpellCheckerBundle.message("custom.dictionary.title", new Object[0])){

                public String valueOf(String info) {
                    return info;
                }

                @Nullable
                public TableCellRenderer getRenderer(String s) {
                    return myTypeRenderer;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dictionaries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultDictionaries";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builtInDictionaries";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTypeRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

