/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a0\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a8\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a0\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a0\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a@\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a9\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001aH\u0082\b\u001a\r\u0010\u001c\u001a\u00020\u001d*\u00020\tH\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"MAX_LONG_MILLIS", "", "estimateAnimationDurationMillis", "stiffness", "", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "", "springConstant", "dampingCoefficient", "mass", "estimateUnderDamped", "firstRootReal", "firstRootImaginary", "p0", "v0", "estimateCriticallyDamped", "estimateOverDamped", "secondRootReal", "estimateDurationInternal", "initialPosition", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "isNotFinite", "", "animation-core"})
@SourceDebugExtension(value={"SMAP\nSpringEstimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,346:1\n345#1:347\n345#1:349\n342#1:351\n345#1:352\n345#1:354\n342#1:356\n150#2:348\n150#2:350\n150#2:353\n150#2:355\n150#2:357\n*S KotlinDebug\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n172#1:347\n173#1:349\n212#1:351\n246#1:352\n247#1:354\n292#1:356\n172#1:348\n173#1:350\n246#1:353\n247#1:355\n345#1:357\n*E\n"})
public final class SpringEstimationKt {
    private static final long MAX_LONG_MILLIS = 9223372036854L;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        if (dampingRatio == 0.0f) {
            return 9223372036854L;
        }
        return SpringEstimationKt.estimateAnimationDurationMillis((double)stiffness, (double)dampingRatio, (double)initialVelocity, (double)initialDisplacement, (double)delta);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        double dampingCoefficient = 2.0 * dampingRatio * Math.sqrt(stiffness);
        double partialRoot = dampingCoefficient * dampingCoefficient - 4.0 * stiffness;
        double partialRootReal = partialRoot < 0.0 ? 0.0 : Math.sqrt(partialRoot);
        double partialRootImaginary = partialRoot < 0.0 ? Math.sqrt(Math.abs(partialRoot)) : 0.0;
        double firstRootReal = (-dampingCoefficient + partialRootReal) * 0.5;
        double firstRootImaginary = partialRootImaginary * 0.5;
        double secondRootReal = (-dampingCoefficient - partialRootReal) * 0.5;
        return SpringEstimationKt.estimateDurationInternal(firstRootReal, firstRootImaginary, secondRootReal, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final long estimateAnimationDurationMillis(double springConstant, double dampingCoefficient, double mass, double initialVelocity, double initialDisplacement, double delta) {
        double criticalDamping = 2.0 * Math.sqrt(springConstant * mass);
        double dampingRatio = dampingCoefficient / criticalDamping;
        double partialRoot = dampingCoefficient * dampingCoefficient - 4.0 * mass * springConstant;
        double divisor = 1.0 / (2.0 * mass);
        double partialRootReal = partialRoot < 0.0 ? 0.0 : Math.sqrt(partialRoot);
        double partialRootImaginary = partialRoot < 0.0 ? Math.sqrt(Math.abs(partialRoot)) : 0.0;
        double firstRootReal = (-dampingCoefficient + partialRootReal) * divisor;
        double firstRootImaginary = partialRootImaginary * divisor;
        double secondRootReal = (-dampingCoefficient - partialRootReal) * divisor;
        return SpringEstimationKt.estimateDurationInternal(firstRootReal, firstRootImaginary, secondRootReal, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    private static final double estimateUnderDamped(double firstRootReal, double firstRootImaginary, double p0, double v0, double delta) {
        double r = firstRootReal;
        double c1 = p0;
        double c2 = (v0 - r * c1) / firstRootImaginary;
        double c = Math.sqrt(c1 * c1 + c2 * c2);
        return Math.log(delta / c) / r;
    }

    private static final double estimateCriticallyDamped(double firstRootReal, double p0, double v0, double delta) {
        double d;
        double d2;
        double guess;
        double r = firstRootReal;
        double c1 = p0;
        double c2 = v0 - r * c1;
        double t1 = Math.log(Math.abs(delta / c1)) / r;
        boolean bl = false;
        double t = guess = Math.log(Math.abs(delta / c2));
        for (int i = 0; i < 6; ++i) {
            t = guess - Math.log(Math.abs(t / r));
        }
        double t2 = t / r;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
        boolean $i$f$fastIsFinite = false;
        if (!((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
            $i$f$fastIsFinite = false;
            d2 = !((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        double xInflection = c1 * Math.exp(r * tInflection) + c2 * tInflection * Math.exp(r * tInflection);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -xInflection < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            tCurr = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t3;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d3 = tCurr;
            double d4 = tCurr;
            boolean bl2 = false;
            double d5 = (c1 + c2 * t3) * Math.exp(r * t3) + signedDelta;
            t3 = tCurr;
            boolean bl3 = false;
            double d6 = (c2 * (r * t3 + 1.0) + c1 * r) * Math.exp(r * t3);
            tCurr = d4 - d5 / d6;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final double estimateOverDamped(double firstRootReal, double secondRootReal, double p0, double v0, double delta) {
        double signedDelta;
        double d;
        double d2;
        double r1 = firstRootReal;
        double r2 = secondRootReal;
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double t1 = Math.log(Math.abs(delta / c1)) / r1;
        double t2 = Math.log(Math.abs(delta / c2)) / r2;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
        boolean $i$f$fastIsFinite = false;
        if (!((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
            $i$f$fastIsFinite = false;
            d2 = !((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = Math.log(c1 * r1 / (-c2 * r2)) / (r2 - r1);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection(c1, r1, tInflection, c2, r2) < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            tCurr = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
            d = signedDelta = delta;
        }
        if (Math.abs(c1 * r1 * Math.exp(r1 * tCurr) + c2 * r2 * Math.exp(r2 * tCurr)) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d3 = tCurr;
            double d4 = tCurr;
            boolean bl = false;
            double d5 = c1 * Math.exp(r1 * t) + c2 * Math.exp(r2 * t) + signedDelta;
            t = tCurr;
            boolean bl2 = false;
            double d6 = c1 * r1 * Math.exp(r1 * t) + c2 * r2 * Math.exp(r2 * t);
            tCurr = d4 - d5 / d6;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(double firstRootReal, double firstRootImaginary, double secondRootReal, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(firstRootReal, secondRootReal, p0, v0, delta) : (dampingRatio < 1.0 ? SpringEstimationKt.estimateUnderDamped(firstRootReal, firstRootImaginary, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(firstRootReal, p0, v0, delta))) * 1000.0);
    }

    private static final double iterateNewtonsMethod(double x, Function1<? super Double, Double> fn, Function1<? super Double, Double> fnPrime) {
        boolean $i$f$iterateNewtonsMethod = false;
        return x - ((Number)fn.invoke((Object)x)).doubleValue() / ((Number)fnPrime.invoke((Object)x)).doubleValue();
    }

    private static final boolean isNotFinite(double $this$isNotFinite) {
        boolean $i$f$isNotFinite = false;
        double $this$fastIsFinite$iv = $this$isNotFinite;
        boolean $i$f$fastIsFinite = false;
        return !((Double.doubleToRawLongBits($this$fastIsFinite$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L);
    }

    private static final double estimateOverDamped$xInflection(double c1, double r1, double tInflection, double c2, double r2) {
        return c1 * Math.exp(r1 * tInflection) + c2 * Math.exp(r2 * tInflection);
    }
}

