/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Adaptable {
    private final List<Object> adapters;

    Adaptable(List<Object> adapters) {
        this.adapters = adapters;
    }

    public <T> T getAdapter(Class<T> type) {
        for (Object o : this.adapters) {
            if (type != o.getClass()) continue;
            return (T)o;
        }
        for (Object o : this.adapters) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            return (T)o;
        }
        return null;
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected List<Object> adapters = null;

        public B adapter(Object adapter) {
            if (this.adapters == null) {
                this.adapters = new ArrayList<Object>();
            }
            this.adapters.add(adapter);
            return (B)this;
        }

        public B adapters(Collection<Object> adapters) {
            if (this.adapters == null) {
                this.adapters = new ArrayList<Object>(adapters);
            } else {
                this.adapters.addAll(adapters);
            }
            return (B)this;
        }

        public B adapters(Object ... adapters) {
            if (this.adapters == null) {
                this.adapters = new ArrayList<Object>(adapters.length);
            }
            for (Object adapter : adapters) {
                this.adapters.add(adapter);
            }
            return (B)this;
        }

        protected List<Object> sealAdapters() {
            if (this.adapters == null) {
                return Collections.emptyList();
            }
            List<Object> useAdapters = this.adapters;
            this.adapters = null;
            return Collections.unmodifiableList(useAdapters);
        }
    }
}

