/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import java.util.StringTokenizer;

public class Location {
    private final int column;
    private final int line;
    private final int offset;

    public static Location parse(String locationString) {
        StringTokenizer st = new StringTokenizer(locationString, ": ()");
        if (st.hasMoreTokens()) {
            int line = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                int column = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    int offset = Integer.parseInt(st.nextToken());
                    return new Location(offset, line, column);
                }
            }
        }
        throw new IllegalArgumentException("Cannot parse \"" + locationString + "\" into a " + Location.class.getName());
    }

    public Location(int offset, int line, int column) {
        this.offset = offset;
        this.column = column;
        this.line = line;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return this.offset == other.offset && this.column == other.column && this.line == other.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return this.offset;
    }

    public String toString() {
        return this.line + ":" + this.column + " (" + this.offset + ")";
    }
}

