/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.intellij.openapi.util.Version;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0013R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/psi/impl/PyVersionCheck;", "", "<init>", "()V", "convertToVersionRanges", "Lcom/google/common/collect/ImmutableRangeSet;", "Lcom/intellij/openapi/util/Version;", "ifPart", "Lcom/jetbrains/python/psi/PyIfPart;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "SYS_VERSION_INFO_QUALIFIED_NAME", "Lcom/intellij/psi/util/QualifiedName;", "Lorg/jetbrains/annotations/NotNull;", "evaluateVersion", "versionTuple", "Lcom/jetbrains/python/psi/PyTupleExpression;", "evaluateNumber", "", "(Lcom/jetbrains/python/psi/PyExpression;)Ljava/lang/Integer;", "intellij.python.psi"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyVersionCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVersionCheck.kt\ncom/jetbrains/python/psi/impl/PyVersionCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class PyVersionCheck {
    @NotNull
    public static final PyVersionCheck INSTANCE = new PyVersionCheck();
    @NotNull
    private static final QualifiedName SYS_VERSION_INFO_QUALIFIED_NAME;

    private PyVersionCheck() {
    }

    @JvmStatic
    @Nullable
    public static final ImmutableRangeSet<Version> convertToVersionRanges(@NotNull PyIfPart ifPart) {
        ImmutableRangeSet<Version> immutableRangeSet;
        Intrinsics.checkNotNullParameter((Object)ifPart, (String)"ifPart");
        PyExpression pyExpression = (PyExpression)ifPart.getCondition();
        if (pyExpression != null) {
            PyExpression pyExpression2 = pyExpression;
            PyVersionCheck pyVersionCheck = INSTANCE;
            PyExpression p0 = pyExpression2;
            boolean bl = false;
            immutableRangeSet = pyVersionCheck.convertToVersionRanges(p0);
        } else {
            immutableRangeSet = null;
        }
        return immutableRangeSet;
    }

    private final ImmutableRangeSet<Version> convertToVersionRanges(PyExpression expression) {
        PyExpression pyExpression = PyPsiUtils.flattenParens(expression);
        PyBinaryExpression pyBinaryExpression = pyExpression instanceof PyBinaryExpression ? (PyBinaryExpression)pyExpression : null;
        if (pyBinaryExpression == null) {
            return null;
        }
        PyBinaryExpression binaryExpr = pyBinaryExpression;
        PyElementType operator = binaryExpr.getOperator();
        if (Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.AND_KEYWORD)) || Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.OR_KEYWORD))) {
            PyExpression pyExpression2 = binaryExpr.getRightExpression();
            if (pyExpression2 == null) {
                return null;
            }
            PyExpression rhs = pyExpression2;
            PyExpression pyExpression3 = binaryExpr.getLeftExpression();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression3, (String)"getLeftExpression(...)");
            ImmutableRangeSet<Version> immutableRangeSet = this.convertToVersionRanges(pyExpression3);
            if (immutableRangeSet == null) {
                return null;
            }
            ImmutableRangeSet<Version> ranges1 = immutableRangeSet;
            ImmutableRangeSet<Version> immutableRangeSet2 = this.convertToVersionRanges(rhs);
            if (immutableRangeSet2 == null) {
                return null;
            }
            ImmutableRangeSet<Version> ranges2 = immutableRangeSet2;
            return operator == PyTokenTypes.AND_KEYWORD ? ranges1.intersection((RangeSet)ranges2) : ranges1.union((RangeSet)ranges2);
        }
        if (Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.LT)) || Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.GT)) || Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.LE)) || Intrinsics.areEqual((Object)((Object)operator), (Object)((Object)PyTokenTypes.GE))) {
            Range range;
            PyExpression ranges2 = PyPsiUtils.flattenParens(binaryExpr.getLeftExpression());
            PyReferenceExpression pyReferenceExpression = ranges2 instanceof PyReferenceExpression ? (PyReferenceExpression)ranges2 : null;
            if (pyReferenceExpression == null) {
                return null;
            }
            PyReferenceExpression refExpr = pyReferenceExpression;
            if (!Intrinsics.areEqual((Object)SYS_VERSION_INFO_QUALIFIED_NAME, (Object)refExpr.asQualifiedName())) {
                return null;
            }
            PyExpression pyExpression4 = PyPsiUtils.flattenParens(binaryExpr.getRightExpression());
            PyTupleExpression pyTupleExpression = pyExpression4 instanceof PyTupleExpression ? (PyTupleExpression)pyExpression4 : null;
            if (pyTupleExpression == null) {
                return null;
            }
            PyTupleExpression tuple = pyTupleExpression;
            Version version2 = this.evaluateVersion(tuple);
            if (version2 == null) {
                return null;
            }
            Version version3 = version2;
            PyElementType pyElementType = operator;
            if (Intrinsics.areEqual((Object)((Object)pyElementType), (Object)((Object)PyTokenTypes.LT))) {
                range = Range.lessThan((Comparable)((Comparable)version3));
            } else if (Intrinsics.areEqual((Object)((Object)pyElementType), (Object)((Object)PyTokenTypes.GT))) {
                range = Range.greaterThan((Comparable)((Comparable)version3));
            } else if (Intrinsics.areEqual((Object)((Object)pyElementType), (Object)((Object)PyTokenTypes.LE))) {
                range = Range.atMost((Comparable)((Comparable)version3));
            } else if (Intrinsics.areEqual((Object)((Object)pyElementType), (Object)((Object)PyTokenTypes.GE))) {
                range = Range.atLeast((Comparable)((Comparable)version3));
            } else {
                throw new IllegalStateException();
            }
            Range range2 = range;
            Intrinsics.checkNotNull((Object)range2);
            Range range3 = range2;
            return ImmutableRangeSet.of((Range)range3);
        }
        return null;
    }

    private final Version evaluateVersion(PyTupleExpression versionTuple) {
        PyAstExpression[] pyAstExpressionArray = versionTuple.getElements();
        Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
        PyExpression[] elements = (PyExpression[])pyAstExpressionArray;
        if (elements.length != 1 && elements.length != 2) {
            return null;
        }
        Integer major = this.evaluateNumber(elements[0]);
        if (major == null) {
            return null;
        }
        if (elements.length == 1) {
            return new Version(major.intValue(), 0, 0);
        }
        Integer minor = this.evaluateNumber(elements[1]);
        if (minor == null) {
            return null;
        }
        return new Version(major.intValue(), minor.intValue(), 0);
    }

    private final Integer evaluateNumber(PyExpression expression) {
        if (!(expression instanceof PyNumericLiteralExpression)) {
            return null;
        }
        if (!((PyNumericLiteralExpression)expression).isIntegerLiteral()) {
            return null;
        }
        BigInteger bigInteger = ((PyNumericLiteralExpression)expression).getBigIntegerValue();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getBigIntegerValue(...)");
        BigInteger value = bigInteger;
        int intValue = value.intValue();
        return Intrinsics.areEqual((Object)BigInteger.valueOf(intValue), (Object)value) ? Integer.valueOf(intValue) : null;
    }

    static {
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)"sys.version_info");
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(...)");
        SYS_VERSION_INFO_QUALIFIED_NAME = qualifiedName;
    }
}

