/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.actions.Conflict;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/svn/actions/ChangeConflict;", "Lorg/jetbrains/idea/svn/actions/Conflict;", "change", "Lorg/jetbrains/idea/svn/ConflictedSvnChange;", "<init>", "(Lorg/jetbrains/idea/svn/ConflictedSvnChange;)V", "getChange", "()Lorg/jetbrains/idea/svn/ConflictedSvnChange;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "conflictState", "Lorg/jetbrains/idea/svn/ConflictState;", "getConflictState", "()Lorg/jetbrains/idea/svn/ConflictState;", "getPathsToRefresh", "", "intellij.vcs.svn"})
final class ChangeConflict
implements Conflict {
    @NotNull
    private final ConflictedSvnChange change;

    public ChangeConflict(@NotNull ConflictedSvnChange change) {
        Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
        this.change = change;
    }

    @NotNull
    public final ConflictedSvnChange getChange() {
        return this.change;
    }

    @Override
    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.change.getTreeConflictMarkHolder();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getTreeConflictMarkHolder(...)");
        return filePath;
    }

    @Override
    @NotNull
    public ConflictState getConflictState() {
        ConflictState conflictState = this.change.getConflictState();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)conflictState), (String)"getConflictState(...)");
        return conflictState;
    }

    @Override
    @NotNull
    public Collection<FilePath> getPathsToRefresh() {
        FilePath beforePath = ChangesUtil.getBeforePath((Change)this.change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)this.change);
        boolean isAddMoveRename = beforePath == null || this.change.isMoved() || this.change.isRenamed();
        Object[] objectArray = new FilePath[]{beforePath, isAddMoveRename ? afterPath : null};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }
}

