/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.browser.CopyOptionsDialog;

public class DeleteOptionsDialog
extends DialogWrapper {
    private JTextArea myCommitMessage;
    private final Project myProject;

    public DeleteOptionsDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(SvnBundle.message("dialog.title.svn.delete", new Object[0]));
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.delete.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.commit.message", new Object[0])), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.fill = 1;
        this.myCommitMessage = new JTextArea(10, 0);
        this.myCommitMessage.setWrapStyleWord(true);
        this.myCommitMessage.setLineWrap(true);
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessage), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 11;
        gc.fill = 2;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.recent.messages", new Object[0])), gc);
        ++gc.gridy;
        ComboBox<String> messagesBox = CopyOptionsDialog.configureRecentMessagesComponent(this.myProject, (ComboBox<String>)new ComboBox(), message -> {
            this.myCommitMessage.setText((String)message);
            this.myCommitMessage.selectAll();
        });
        panel2.add((Component)messagesBox, gc);
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessage;
    }
}

