/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.AbstractSvnUpdateIntegrateEnvironment;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.SvnIntegratePanel;
import org.jetbrains.idea.svn.update.SvnUpdateConfigurable;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public class SvnIntegrateEnvironment
extends AbstractSvnUpdateIntegrateEnvironment {
    public SvnIntegrateEnvironment(SvnVcs vcs) {
        super(vcs);
    }

    @Override
    protected AbstractUpdateIntegrateCrawler createCrawler(UpdateEventHandler eventHandler, boolean totalUpdate, ArrayList<VcsException> exceptions, UpdatedFiles updatedFiles) {
        return new IntegrateCrawler(this.myVcs, eventHandler, totalUpdate, exceptions, updatedFiles);
    }

    @Override
    public Configurable createConfigurable(final Collection<FilePath> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return new SvnUpdateConfigurable(this.myVcs.getProject()){

            @Override
            protected AbstractSvnUpdatePanel createPanel() {
                return new SvnIntegratePanel(SvnIntegrateEnvironment.this.myVcs, collection);
            }

            public String getDisplayName() {
                return SvnBundle.message("integrate.display.name", new Object[0]);
            }

            @Override
            public String getHelpTopic() {
                return "reference.dialogs.versionControl.integrate.project.subversion";
            }
        };
    }

    @Override
    protected boolean isDryRun() {
        return this.myVcs.getSvnConfiguration().isMergeDryRun();
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private static class IntegrateCrawler
    extends AbstractUpdateIntegrateCrawler {
        IntegrateCrawler(SvnVcs vcs, UpdateEventHandler handler, boolean totalUpdate, Collection<VcsException> exceptions, UpdatedFiles postUpdateFiles) {
            super(totalUpdate, postUpdateFiles, exceptions, handler, vcs);
        }

        @Override
        protected void showProgressMessage(ProgressIndicator progress, File root) {
            if (this.myVcs.getSvnConfiguration().isMergeDryRun()) {
                progress.setText(SvnBundle.message("progress.text.merging.dry.run.changes", root.getAbsolutePath()));
            } else {
                progress.setText(SvnBundle.message("progress.text.merging.changes", root.getAbsolutePath()));
            }
        }

        @Override
        protected long doUpdate(File root) throws VcsException {
            SvnConfiguration svnConfig = this.myVcs.getSvnConfiguration();
            MergeRootInfo info = svnConfig.getMergeRootInfo(root, this.myVcs);
            if (info.getUrlString1().equals(info.getUrlString2()) && info.getRevision1().equals(info.getRevision2())) {
                return 0L;
            }
            MergeClient client = this.myVcs.getFactory(root).createMergeClient();
            Target source1 = Target.on(info.getUrl1(), info.getRevision1());
            Target source2 = Target.on(info.getUrl2(), info.getRevision2());
            client.merge(source1, source2, root, svnConfig.getUpdateDepth(), svnConfig.isMergeDiffUseAncestry(), svnConfig.isMergeDryRun(), false, false, svnConfig.getMergeOptions(), this.myHandler);
            return info.getResultRevision();
        }

        @Override
        protected boolean isMerge() {
            return true;
        }
    }
}

