/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretModel;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.block.output.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0007J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020$H\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002J\b\u0010*\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "terminalModel", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "getTerminalModel", "()Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "caretModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretPainter;", "isFocused", "", "()Z", "setFocused", "(Z)V", "clearTextSelection", "", "setupContentListener", "updateEditorContent", "computeTerminalContent", "Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "updateEditor", "content", "toTextAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "Lcom/jediterm/terminal/TextStyle;", "dispose", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSimpleTerminalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTerminalController.kt\norg/jetbrains/plugins/terminal/block/SimpleTerminalController\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n1#1,148:1\n158#2,7:149\n*S KotlinDebug\n*F\n+ 1 SimpleTerminalController.kt\norg/jetbrains/plugins/terminal/block/SimpleTerminalController\n*L\n56#1:149,7\n*E\n"})
public final class SimpleTerminalController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalCaretModel caretModel;
    @NotNull
    private final TerminalCaretPainter caretPainter;
    private boolean isFocused;
    @NotNull
    private static final DataKey<SimpleTerminalController> KEY = DataKey.Companion.create("SimpleTerminalController");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTerminalController(@NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.session = session2;
        this.editor = editor;
        this.outputModel = new TerminalOutputModelImpl(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.caretModel = new TerminalCaretModel(this.session, this.outputModel, this.editor, this);
        this.caretPainter = new TerminalCaretPainter(this.caretModel, this.outputModel, this.selectionModel, this.editor);
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_ALTERNATE_BUFFER_EDITOR_KEY$intellij_terminal(), (Object)true);
        Disposer.register((Disposable)this, (Disposable)this.caretPainter);
        this.outputModel.createBlock(null, null, this.session.getModel().getWidth());
        this.getTerminalModel().setCommandRunning(true);
        this.setupContentListener();
        SimpleTerminalEventsHandler eventsHandler = new SimpleTerminalEventsHandler(this.session, settings, this.outputModel);
        TerminalEventDispatcherKt.setupKeyEventDispatcher(this.editor, eventsHandler, this);
        TerminalEventDispatcherKt.setupMouseListener(this.editor, settings, this.getTerminalModel(), eventsHandler, this);
        TerminalEventDispatcherKt.setupInputMethodSupport(this.editor, this.session, this.caretModel, this);
        TerminalModel this_$iv = this.getTerminalModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.updateEditorContent();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    @NotNull
    public final Document getDocument() {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return (Document)documentEx;
    }

    private final TerminalModel getTerminalModel() {
        return this.session.getModel();
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    public final void setFocused(boolean bl) {
        this.isFocused = bl;
    }

    @RequiresEdt
    public final void clearTextSelection() {
        this.editor.getSelectionModel().removeSelection();
    }

    private final void setupContentListener() {
        this.getTerminalModel().addContentListener(new TerminalModel.ContentListener(this){
            final /* synthetic */ SimpleTerminalController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onContentChanged() {
                SimpleTerminalController.access$updateEditorContent(this.this$0);
            }
        }, this);
    }

    private final void updateEditorContent() {
        TextWithHighlightings content = this.computeTerminalContent();
        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.editor);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> SimpleTerminalController.updateEditorContent$lambda$1(this, content));
    }

    private final TextWithHighlightings computeTerminalContent() {
        StringBuilder builder = new StringBuilder();
        List highlightings = new ArrayList();
        StyledTextConsumer consumer2 = new StyledTextConsumer(builder, highlightings, this){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ List<HighlightingInfo> $highlightings;
            final /* synthetic */ SimpleTerminalController this$0;
            {
                this.$builder = $builder;
                this.$highlightings = $highlightings;
                this.this$0 = $receiver;
            }

            public void consume(int x, int y, TextStyle style, CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                this.$builder.append(characters.toString());
                this.$highlightings.add(new HighlightingInfo(startOffset, this.$builder.length(), SimpleTerminalController.access$toTextAttributesProvider(this.this$0, style)));
            }

            public void consumeNul(int x, int y, int nulIndex, TextStyle style, CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                int n = characters.getBuf().length;
                StringBuilder stringBuilder = this.$builder;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    stringBuilder.append(' ');
                }
                int n3 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(startOffset, n3, SimpleTerminalController.access$toTextAttributesProvider(this.this$0, textStyle)));
            }

            public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                this.$builder.append("\n");
                int n = this.$builder.length() - 1;
                int n2 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(n, n2, SimpleTerminalController.access$toTextAttributesProvider(this.this$0, textStyle)));
            }
        };
        if (this.getTerminalModel().getUseAlternateBuffer()) {
            this.getTerminalModel().processScreenLines(0, this.getTerminalModel().getScreenLinesCount(), consumer2);
        } else {
            this.getTerminalModel().processHistoryAndScreenLines(-this.getTerminalModel().getHistoryLinesCount(), this.getTerminalModel().getHistoryLinesCount() + this.getTerminalModel().getCursorY(), consumer2);
        }
        while (true) {
            Character c = StringsKt.lastOrNull((CharSequence)builder);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) break;
            builder.deleteCharAt(StringsKt.getLastIndex((CharSequence)builder));
            CollectionsKt.removeLast((List)highlightings);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new TextWithHighlightings(string, highlightings);
    }

    private final void updateEditor(TextWithHighlightings content) {
        this.getDocument().setText((CharSequence)content.getText());
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.editor.setHighlighter((EditorHighlighter)new TerminalTextHighlighter(new TerminalOutputHighlightingsSnapshot((Document)documentEx, content.getHighlightings())));
        int line = this.getTerminalModel().getHistoryLinesCount() + this.getTerminalModel().getCursorY() - 1;
        this.editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, this.getTerminalModel().getCursorX()));
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
        this.caretPainter.repaint();
    }

    private final TextAttributesProvider toTextAttributesProvider(TextStyle $this$toTextAttributesProvider) {
        return new TextStyleAdapter($this$toTextAttributesProvider, this.session.getColorPalette());
    }

    public void dispose() {
    }

    private static final void updateEditorContent$lambda$1(SimpleTerminalController this$0, TextWithHighlightings $content) {
        this$0.updateEditor($content);
    }

    public static final /* synthetic */ void access$updateEditorContent(SimpleTerminalController $this) {
        $this.updateEditorContent();
    }

    public static final /* synthetic */ TextAttributesProvider access$toTextAttributesProvider(SimpleTerminalController $this, TextStyle $receiver) {
        return $this.toTextAttributesProvider($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<SimpleTerminalController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

