/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class AddCommasFilter
extends RuleFilter {
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\u00ab\u201c\"\u2018'\u201e\u00bf\u00a1]", 32);

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        boolean afterOK;
        int postagTo;
        int postagFrom;
        String suggestSemicolon = this.getOptional("suggestSemicolon", arguments);
        boolean bSuggestSemicolon = false;
        if (suggestSemicolon != null && suggestSemicolon.equalsIgnoreCase("true")) {
            bSuggestSemicolon = true;
        }
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (postagFrom = 1; postagFrom < tokens.length && tokens[postagFrom].getStartPos() < match.getFromPos(); ++postagFrom) {
        }
        for (postagTo = postagFrom; postagTo < tokens.length && tokens[postagTo].getEndPos() < match.getToPos(); ++postagTo) {
        }
        boolean beforeOK = postagFrom == 1 || StringTools.isPunctuationMark(tokens[postagFrom - 1].getToken()) || StringTools.isCapitalizedWord(tokens[postagFrom].getToken());
        boolean bl = afterOK = postagTo + 1 <= tokens.length - 1 && StringTools.isPunctuationMark(tokens[postagTo + 1].getToken()) && (!tokens[postagTo + 1].isWhitespaceBefore() || !OPENING_QUOTES.matcher(tokens[postagTo + 1].getToken()).matches());
        if (beforeOK && afterOK) {
            return null;
        }
        RuleMatch newMatch = null;
        if (bSuggestSemicolon && tokens[postagFrom - 1].getToken().equals(",") && !afterOK) {
            newMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[postagFrom - 1].getStartPos(), tokens[postagTo].getEndPos(), match.getMessage(), match.getShortMessage());
            newMatch.addSuggestedReplacement("; " + match.getSentence().getText().substring(match.getFromPos(), match.getToPos()) + ",");
            newMatch.addSuggestedReplacement(", " + match.getSentence().getText().substring(match.getFromPos(), match.getToPos()) + ",");
        } else if (beforeOK && !afterOK) {
            newMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[postagTo].getStartPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
            newMatch.setSuggestedReplacement(tokens[postagTo].getToken() + ",");
        } else if (!beforeOK && afterOK) {
            int startPos = tokens[postagFrom].getStartPos();
            if (tokens[postagFrom].isWhitespaceBefore()) {
                --startPos;
            }
            newMatch = new RuleMatch(match.getRule(), match.getSentence(), startPos, tokens[postagFrom].getEndPos(), match.getMessage(), match.getShortMessage());
            newMatch.setSuggestedReplacement(", " + tokens[postagFrom].getToken());
        } else if (!beforeOK && !afterOK) {
            int startPos = tokens[postagFrom].getStartPos();
            if (tokens[postagFrom].isWhitespaceBefore()) {
                --startPos;
            }
            newMatch = new RuleMatch(match.getRule(), match.getSentence(), startPos, tokens[postagTo].getEndPos(), match.getMessage(), match.getShortMessage());
            newMatch.setSuggestedReplacement(", " + match.getSentence().getText().substring(match.getFromPos(), match.getToPos()) + ",");
        }
        return newMatch;
    }
}

