/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBinaryContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContentRevision
implements ByteBackedContentRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private FilePath filePath;

    protected HgContentRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        if (hgFile == null) {
            HgContentRevision.$$$reportNull$$$0(0);
        }
        if (revisionNumber == null) {
            HgContentRevision.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myRevisionNumber = revisionNumber;
    }

    @NotNull
    public static HgContentRevision create(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        if (hgFile == null) {
            HgContentRevision.$$$reportNull$$$0(2);
        }
        if (revisionNumber == null) {
            HgContentRevision.$$$reportNull$$$0(3);
        }
        return !hgFile.toFilePath().getFileType().isBinary() ? new HgContentRevision(project, hgFile, revisionNumber) : new HgBinaryContentRevision(project, hgFile, revisionNumber);
    }

    @Nullable
    public String getContent() {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileContent((String)this.myHgFile.getFile().getPath());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return CharsetToolkit.bytesToString((byte[])HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat), (Charset)this.getFile().getCharset());
    }

    public byte[] getContentAsBytes() {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileByteContent((File)this.myHgFile.getFile());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
    }

    @NotNull
    public FilePath getFile() {
        if (this.filePath == null) {
            this.filePath = this.myHgFile.toFilePath();
        }
        FilePath filePath = this.filePath;
        if (filePath == null) {
            HgContentRevision.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevisionNumber;
        if (hgRevisionNumber == null) {
            HgContentRevision.$$$reportNull$$$0(5);
        }
        return hgRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgContentRevision revision = (HgContentRevision)o;
        if (!this.myHgFile.equals(revision.myHgFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.myHgFile, this.myRevisionNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgContentRevision";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

