/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.AbstractCopyrightManager;
import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.copyright.IdeCopyrightManager;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.StatusText;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.ExternalOptionHelper;
import com.maddyhome.idea.copyright.ui.CopyrightConfigurable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CopyrightProfilesPanel
extends MasterDetailsComponent
implements SearchableConfigurable {
    private final Project myProject;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private final CopyrightManager myCopyrightManager;
    private final IdeCopyrightManager myIdeCopyrightManager;
    private Runnable myUpdate;

    CopyrightProfilesPanel(Project project) {
        this.myProject = project;
        this.initTree();
        this.myCopyrightManager = CopyrightManager.getInstance(this.myProject);
        this.myIdeCopyrightManager = IdeCopyrightManager.getInstance();
    }

    protected void initTree() {
        super.initTree();
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, treePath -> {
            MasterDetailsComponent.MyNode obj = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent();
            return obj == null ? null : obj.getDisplayName();
        });
        StatusText emptyText = this.myTree.getEmptyText();
        emptyText.setText(CopyrightBundle.message("copyright.profiles.empty", new Object[0]));
        emptyText.appendSecondaryText(CopyrightBundle.message("copyright.profiles.add.profile", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, __ -> this.doAddProfile(true));
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        if (!shortcutText.isEmpty()) {
            emptyText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
    }

    void setUpdate(Runnable update) {
        this.myUpdate = update;
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected String getComponentStateKey() {
        return "Copyright.UI";
    }

    protected void processRemovedItems() {
        Map<String, CopyrightProfile> profiles = this.getAllProfiles();
        CopyrightProfilesPanel.processRemovedItemps(this.myCopyrightManager, profiles);
        CopyrightProfilesPanel.processRemovedItemps(this.myIdeCopyrightManager, profiles);
    }

    private static void processRemovedItemps(AbstractCopyrightManager manager, Map<String, CopyrightProfile> profiles) {
        for (CopyrightProfile profile : new ArrayList<CopyrightProfile>(manager.getCopyrights())) {
            if (profiles.containsValue((Object)profile)) continue;
            manager.removeCopyright(profile);
        }
    }

    protected boolean wasObjectStored(Object o) {
        CopyrightProfile profile = (CopyrightProfile)((Object)o);
        return this.myCopyrightManager.getCopyrights().contains((Object)profile) || this.myIdeCopyrightManager.getCopyrights().contains((Object)profile);
    }

    public String getDisplayName() {
        return CopyrightBundle.message("configurable.CopyrightProfilesPanel.display.name", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        return "copyright.profiles";
    }

    private void reloadAvailableProfiles() {
        if (this.myUpdate != null) {
            this.myUpdate.run();
        }
    }

    public void apply() throws ConfigurationException {
        HashSet<String> profiles = new HashSet<String>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            String profileName = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject().getName();
            if (profiles.contains(profileName)) {
                this.selectNodeInTree(profileName);
                throw new ConfigurationException(CopyrightBundle.message("dialog.message.duplicate.copyright.profile.name", profileName));
            }
            profiles.add(profileName);
        }
        super.apply();
    }

    Map<String, CopyrightProfile> getAllProfiles() {
        HashMap<String, CopyrightProfile> profiles = new HashMap<String, CopyrightProfile>();
        if (!this.myInitialized.get()) {
            for (CopyrightProfile profile : this.myCopyrightManager.getCopyrights()) {
                profiles.put(profile.getName(), profile);
            }
            for (CopyrightProfile profile : this.myIdeCopyrightManager.getCopyrights()) {
                profiles.put(profile.getName(), profile);
            }
        } else {
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
                CopyrightProfile copyrightProfile = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject();
                profiles.put(copyrightProfile.getName(), copyrightProfile);
            }
        }
        return profiles;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myInitialized.set(false);
    }

    private void doAddProfile(boolean shareProfile) {
        String name = this.askForProfileName(CopyrightBundle.message("create.copyright.profile", new Object[0]), "");
        if (name != null) {
            this.addProfileNode(new CopyrightProfile(name), shareProfile);
        }
    }

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new MyAddActionGroup(fromPopup));
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        result.add((AnAction)new DumbAwareAction(CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.text.copy", new Object[0]), CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.copy", new Object[0]), PlatformIcons.COPY_ICON){
            {
                this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                Object object;
                String profileName;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((profileName = CopyrightProfilesPanel.this.askForProfileName(CopyrightBundle.message("copy.copyright.profile", new Object[0]), "")) == null) {
                    return;
                }
                CopyrightProfile clone = new CopyrightProfile();
                CopyrightProfile profile = null;
                boolean sharedProfile = true;
                TreePath selectionPath = CopyrightProfilesPanel.this.myTree.getSelectionPath();
                if (selectionPath != null && (object = selectionPath.getLastPathComponent()) instanceof MasterDetailsComponent.MyNode) {
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)object;
                    NamedConfigurable configurable = node.getConfigurable();
                    LOG.assertTrue(configurable != null, (Object)"already disposed");
                    profile = (CopyrightProfile)((Object)configurable.getEditableObject());
                    sharedProfile = ((CopyrightConfigurable)configurable).isShareProfile();
                }
                CopyrightProfile copyrightProfile = Objects.requireNonNull(profile);
                clone.copyFrom(copyrightProfile);
                clone.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(clone, sharedProfile);
            }

            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                event.getPresentation().setEnabled(CopyrightProfilesPanel.this.getSelectedObject() != null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        result.add((AnAction)new DumbAwareAction(CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.text.import", new Object[0]), CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.import", new Object[0]), PlatformIcons.IMPORT_ICON){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withExtensionFilter(CopyrightBundle.message("copyright.file.chooser.label", new Object[0]), new FileType[]{ModuleFileType.INSTANCE, XmlFileType.INSTANCE}).withTitle(CopyrightBundle.message("copyright.file.chooser.title", new Object[0]));
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)CopyrightProfilesPanel.this.myProject, null, file -> {
                    List<CopyrightProfile> profiles = ExternalOptionHelper.loadOptions(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                    if (profiles == null) {
                        return;
                    }
                    if (!profiles.isEmpty()) {
                        if (profiles.size() == 1) {
                            this.importProfile(profiles.get(0));
                        } else {
                            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CopyrightProfile>(CopyrightBundle.message("popup.title.choose.profile.to.import", new Object[0]), profiles){

                                public PopupStep<?> onChosen(CopyrightProfile selectedValue, boolean finalChoice) {
                                    return this.doFinalStep(() -> this.importProfile(selectedValue));
                                }

                                @NotNull
                                public String getTextFor(CopyrightProfile value) {
                                    String string = value.getName();
                                    if (string == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return string;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$2$1", "getTextFor"));
                                }
                            }).showUnderneathOf((Component)CopyrightProfilesPanel.this.myNorthPanel);
                        }
                    } else {
                        Messages.showWarningDialog((Project)CopyrightProfilesPanel.this.myProject, (String)CopyrightBundle.message("dialog.message.the.selected.file.copyright.settings", new Object[0]), (String)CopyrightBundle.message("dialog.title.import.failure", new Object[0]));
                    }
                });
            }

            private void importProfile(CopyrightProfile copyrightProfile) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName(CopyrightBundle.message("import.copyright.profile", new Object[0]), copyrightProfile.getName());
                if (profileName == null) {
                    return;
                }
                copyrightProfile.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(copyrightProfile, true);
                Messages.showInfoMessage((Project)CopyrightProfilesPanel.this.myProject, (String)CopyrightBundle.message("dialog.message.the.copyright.settings.imported", new Object[0]), (String)CopyrightBundle.message("dialog.title.import.complete", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$2", "actionPerformed"));
            }
        });
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            CopyrightProfilesPanel.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    private String askForProfileName(@NlsContexts.DialogTitle String title, String initialName) {
        return Messages.showInputDialog((String)CopyrightBundle.message("dialog.message.new.copyright.profile.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !CopyrightProfilesPanel.this.getAllProfiles().containsKey(s) && !s.isEmpty();
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    private void addProfileNode(@NotNull CopyrightProfile copyrightProfile, boolean shareProfile) {
        if (copyrightProfile == null) {
            CopyrightProfilesPanel.$$$reportNull$$$0(1);
        }
        CopyrightConfigurable copyrightConfigurable = new CopyrightConfigurable(this.myProject, copyrightProfile, this.TREE_UPDATER, shareProfile);
        copyrightConfigurable.setModified(true);
        MasterDetailsComponent.MyNode node = CopyrightProfilesPanel.createCopyrightNode(copyrightConfigurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
        this.reloadAvailableProfiles();
    }

    @NotNull
    private static MasterDetailsComponent.MyNode createCopyrightNode(CopyrightConfigurable copyrightConfigurable) {
        return new MasterDetailsComponent.MyNode(copyrightConfigurable){

            public String getLocationString() {
                return ((CopyrightConfigurable)this.getConfigurable()).isShareProfile() ? CopyrightBundle.message("copyright.shared.description", new Object[0]) : CopyrightBundle.message("copyright.local.description", new Object[0]);
            }
        };
    }

    protected void removePaths(TreePath ... paths) {
        super.removePaths(paths);
        this.reloadAvailableProfiles();
    }

    private void reloadTree() {
        this.myRoot.removeAllChildren();
        this.createTreeNodes(this.myCopyrightManager.getCopyrights(), true);
        this.createTreeNodes(this.myIdeCopyrightManager.getCopyrights(), false);
        this.myInitialized.set(true);
    }

    private void createTreeNodes(Collection<CopyrightProfile> collection, boolean shareProfile) {
        for (CopyrightProfile profile : collection) {
            CopyrightProfile clone = new CopyrightProfile();
            clone.copyFrom(profile);
            this.addNode(CopyrightProfilesPanel.createCopyrightNode(new CopyrightConfigurable(this.myProject, clone, this.TREE_UPDATER, shareProfile)), this.myRoot);
        }
    }

    public void reset() {
        this.reloadTree();
        super.reset();
    }

    protected String getEmptySelectionString() {
        return CopyrightBundle.message("copyright.profiles.select.profile", new Object[0]);
    }

    void addItemsChangeListener(final Runnable runnable) {
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                ApplicationManager.getApplication().invokeLater(runnable);
            }

            public void itemsExternallyChanged() {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            CopyrightProfilesPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyrightProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addProfileNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private final class MyAddActionGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        private AnAction[] myChildren;
        private final boolean myFromPopup;

        MyAddActionGroup(boolean fromPopup) {
            super(CopyrightBundle.messagePointer("action.add.profile.text", new Object[0]), !fromPopup);
            this.myFromPopup = fromPopup;
            this.getTemplatePresentation().setIcon(LayeredIcon.ADD_WITH_DROPDOWN);
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)CopyrightProfilesPanel.this.myTree);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildren == null) {
                this.myChildren = new AnAction[2];
                this.myChildren[0] = new DumbAwareAction(CopyrightBundle.messagePointer("action.local.text", new Object[0]), CopyrightBundle.messagePointer("action.stored.in.ide.description", new Object[0]), () -> null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        CopyrightProfilesPanel.this.doAddProfile(false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$MyAddActionGroup$1", "actionPerformed"));
                    }
                };
                this.myChildren[1] = new DumbAwareAction(CopyrightBundle.messagePointer("action.shared.text", new Object[0]), CopyrightBundle.messagePointer("action.stored.in.project.description", new Object[0]), () -> null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        CopyrightProfilesPanel.this.doAddProfile(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$MyAddActionGroup$2", "actionPerformed"));
                    }
                };
            }
            if (this.myFromPopup) {
                AnAction action = this.myChildren[this.getDefaultIndex()];
                action.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
                AnAction[] anActionArray = new AnAction[]{action};
                if (anActionArray == null) {
                    MyAddActionGroup.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }
            if (this.myChildren == null) {
                MyAddActionGroup.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            NamedConfigurable namedConfigurable;
            TreePath selectionPath = CopyrightProfilesPanel.this.myTree.getSelectionPath();
            if (selectionPath != null && (namedConfigurable = ((MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof CopyrightConfigurable) {
                CopyrightConfigurable c = (CopyrightConfigurable)namedConfigurable;
                return c.isShareProfile() ? 1 : 0;
            }
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$MyAddActionGroup", "getChildren"));
        }
    }
}

