/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.impl.CachedClasspathComputation;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompactFileWriter {
    public static void saveToFile(@NotNull Collection<RawRuntimeModuleDescriptor> originalDescriptors, @Nullable String bootstrapModuleName, @Nullable String mainPluginModuleId, int generatorVersion, @NotNull Path outputFile) throws IOException {
        if (originalDescriptors == null) {
            CompactFileWriter.$$$reportNull$$$0(0);
        }
        if (outputFile == null) {
            CompactFileWriter.$$$reportNull$$$0(1);
        }
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));){
            out.writeInt(2);
            out.writeInt(generatorVersion);
            boolean hasBootstrap = bootstrapModuleName != null;
            out.writeBoolean(hasBootstrap);
            if (hasBootstrap) {
                out.writeUTF(bootstrapModuleName);
                Collection<String> bootstrapClasspath = CachedClasspathComputation.computeClasspath(originalDescriptors, bootstrapModuleName);
                out.writeInt(bootstrapClasspath.size());
                for (String path : bootstrapClasspath) {
                    out.writeUTF(path);
                }
            }
            boolean hasMainPluginModule = mainPluginModuleId != null;
            out.writeBoolean(hasMainPluginModule);
            if (hasMainPluginModule) {
                out.writeUTF(mainPluginModuleId);
            }
            ArrayList<RawRuntimeModuleDescriptor> descriptors = new ArrayList<RawRuntimeModuleDescriptor>(originalDescriptors);
            Collections.sort(descriptors, Comparator.comparing(RawRuntimeModuleDescriptor::getId));
            HashMap<String, Integer> indexes = new HashMap<String, Integer>(descriptors.size());
            for (int i = 0; i < descriptors.size(); ++i) {
                indexes.put(((RawRuntimeModuleDescriptor)descriptors.get(i)).getId(), i);
            }
            ArrayList<String> unresolvedDependencies = new ArrayList<String>();
            for (RawRuntimeModuleDescriptor descriptor : descriptors) {
                for (String dependency : descriptor.getDependencies()) {
                    if (indexes.containsKey(dependency)) continue;
                    unresolvedDependencies.add(dependency);
                    int nextId = indexes.size();
                    indexes.put(dependency, nextId);
                }
            }
            out.writeInt(descriptors.size());
            out.writeInt(unresolvedDependencies.size());
            for (RawRuntimeModuleDescriptor descriptor : descriptors) {
                out.writeUTF(descriptor.getId());
            }
            for (String dependency : unresolvedDependencies) {
                out.writeUTF(dependency);
            }
            for (RawRuntimeModuleDescriptor descriptor : descriptors) {
                out.writeInt(descriptor.getDependencies().size());
                for (String dependency : descriptor.getDependencies()) {
                    Integer index = (Integer)indexes.get(dependency);
                    if (index == null) {
                        throw new AssertionError((Object)("Unknown dependency '" + dependency + "' in '" + descriptor.getId() + "'"));
                    }
                    out.writeInt(index);
                }
                out.writeInt(descriptor.getResourcePaths().size());
                for (String path : descriptor.getResourcePaths()) {
                    out.writeUTF(path);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "originalDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/runtime/repository/serialization/impl/CompactFileWriter";
        objectArray[2] = "saveToFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

